/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf.draw;

import com.openexchange.office.filter.api.OCKey;
import com.openexchange.office.filter.odf.AttributesImpl;
import com.openexchange.office.filter.odf.OdfOperationDoc;
import com.openexchange.office.filter.odf.OpAttrs;

public class Ellipse extends Shape {

    public Ellipse(AttributesImpl attributes, String uri, String localName, String qName, GroupShape parentGroup, boolean rootShape, boolean contentStyle) {
        super(attributes, uri, localName, qName, parentGroup, rootShape, contentStyle);
    }

    @Override
    public void createAttrs(OdfOperationDoc operationDocument, OpAttrs attrs, boolean contentAutoStyle) {
        super.createAttrs(operationDocument, attrs, contentAutoStyle);

        final String kind = attributes.getValue("draw:kind");
        final String predefinedShape;
        if("section".equals(kind)) {
            predefinedShape = "pie";
        }
        else if("cut".equals(kind)) {
            predefinedShape = "chord";
        }
        else if("arc".equals(kind)) {
            predefinedShape = "arc";
            attrs.getMap(OCKey.FILL.value(), true).put(OCKey.TYPE.value(), "none");     // arc in LO is always without fill
        }
        else {  // "full"
            predefinedShape = "ellipse";
        }
        final OpAttrs geometryAttrs = attrs.getMap(OCKey.GEOMETRY.value(), true);
        geometryAttrs.put(OCKey.PRESET_SHAPE.value(), predefinedShape);

        // the direction of start and end angle is different. in LO the direction is counter clockwise, whereas the direction in ooxml is clockwise
        final Double endAngle = attributes.getDoubleValue("draw:start-angle");          // -> start and end angle has to be swapped
        final Double startAngle = attributes.getDoubleValue("draw:end-angle");
        if(startAngle!=null||endAngle!=null) {
            final OpAttrs avList = new OpAttrs();
            geometryAttrs.put(OCKey.AV_LIST.value(), avList);
            if(startAngle!=null) {  // -> adj1
                avList.put("adj1", Double.valueOf((360.0 - startAngle.doubleValue()) * 60000.0).intValue());
            }
            if(endAngle!=null) {    // -> adj2
                avList.put("adj2", Double.valueOf((360.0 - endAngle.doubleValue()) * 60000.0).intValue());
            }
        }
    }
}
