/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.core.spreadsheet;

import org.json.JSONArray;
import org.json.JSONException;
import com.openexchange.office.filter.api.FilterException;
import com.openexchange.office.filter.api.FilterException.ErrorCode;
import com.openexchange.office.filter.core.DLList;
import com.openexchange.office.filter.core.DLNode;
import com.openexchange.office.filter.core.INodeAccessor;

public class SUtil {

    public static void moveSheets(ISpreadsheet<? extends ISheet> spreadsheet, JSONArray sa)
        throws JSONException {

        final DLList<? extends ISheet> sheetList = spreadsheet.getContent();

        int sheetCount = 0;
        final String[] sheetNames = new String[sa.length()];
        DLNode<? extends ISheet> node = sheetList.getFirstNode();
        while(node!=null) {
            sheetNames[sheetCount++] = node.getData().getName();
            node = node.getNext();
        }
        if(sheetCount!=sa.length()) {
            throw new FilterException("sheet count does not match for moveSheets operation", ErrorCode.CRITICAL_ERROR);
        }
        final String[] destSheetNames = new String[sa.length()];
        for(int i=0; i<sa.length(); i++) {
            destSheetNames[i] = sheetNames[sa.getInt(i)];
        }
        for(int i=0; i<sa.length(); i++) {
            int s = getSheetIndex(spreadsheet, destSheetNames[i]);
            if(s!=i) {
                spreadsheet.moveSheet(s, i);
            }
        }
    }

    private static int getSheetIndex(INodeAccessor<? extends ISheet> spreadsheet, String sheetName) {
        DLNode<? extends ISheet> node = spreadsheet.getContent().getFirstNode();
        int i = 0;
        while(node!=null) {
            if(sheetName.equals(node.getData().getName())) {
                return i;
            }
            node = node.getNext();
            i++;
        }
        return -1;
    }
}
