/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.core.spreadsheet;

import org.apache.commons.lang3.mutable.MutableInt;

public final class ColumnRef implements IColumnRowRef {

    private int column;

    public ColumnRef(int column) {
        this.column = column;
    }

    @Override
    public int hashCode() {
        return column;
    }

    @Override
    public String toString() {
        final StringBuilder builder = new StringBuilder(5);
        int i = column;
        while(i>=0) {
            builder.insert(0, (char)('A' + (i % 26)));
            i /= 26;
            i--;
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ColumnRef) {
            return column == ((ColumnRef)obj).getValue();
        }
        return false;
    }

    @Override
    public int compareTo(IColumnRowRef arg0) {
        return getValue() - arg0.getValue();
    }

    @Override
    public int getValue() {
        return column;
    }

    @Override
    public void setValue(int column) {
        this.column = column;
    }

    @Override
    public void move(int offset) {
        this.column += offset;
    }

    @Override
    public ColumnRef deepClone() {
        return clone();
    }

    @Override
    public ColumnRef clone() {
        try {
            return (ColumnRef)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return new ColumnRef(0);
        }
    }

    /*
     * The offset gives the position up from where the row should be parsed.
     *
     * After parsing the offset points to last parsed character + 1 or -1 if
     * no column could be parsed. If nothing could be parsed the column is initialized
     * with 0.
     *
     */
    public static ColumnRef parseColumnRef(String interval, MutableInt offset) {

        int x = 0;
        int characters = 0;
        int characterStartIndex = offset.intValue();
        if(characterStartIndex>=0) {
            if(interval.charAt(characterStartIndex) == '$') {
                characterStartIndex++;
            }
            while((characters+characterStartIndex)<interval.length()) {
                char character = interval.charAt(characterStartIndex+characters);
                if((character<'A')||(character>'Z')) {
                    break;
                }
                characters++;
            }
            if(characters<=0||characters>=6) {
                offset.setValue(-1);
            }
            else {

                final int[] exMap = { 1, 26, 676, 17576, 456976 };

                int i, ex = characters - 1;
                x = -1;

                for(i = 0; i < characters; i++) {
                    x +=((interval.charAt(i+characterStartIndex)-'A')+1)*exMap[ex-i];
                }
                offset.setValue(i+characterStartIndex);
            }
        }
        return new ColumnRef(x);
    }
}
