/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package org.docx4j.w16cid;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.docx4j.adapter.HexNumberIntegerAdapter;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
//   <xsd:complexType name="CT_CommentId" >
//     <xsd:attribute name="paraId" type="w12:ST_LongHexNumber"/>
//     <xsd:attribute name="durableId" type="w12:ST_LongHexNumber"/>
//   </xsd:complexType> *
 *
 */
@XmlRootElement(name="commentId")
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CT_CommentId")
public class CTCommentId
{
    @XmlJavaTypeAdapter(HexNumberIntegerAdapter.class)
    @XmlAttribute(name="paraId", namespace="http://schemas.microsoft.com/office/word/2016/wordml/cid")
    protected Integer paraId;
    @XmlJavaTypeAdapter(HexNumberIntegerAdapter.class)
    @XmlAttribute(name="durableId", namespace="http://schemas.microsoft.com/office/word/2016/wordml/cid")
    protected Integer durableId;

    /**
     * Gets the value of the paraId property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    public Integer getParaId() {
        return paraId;
    }

    /**
     * Sets the value of the paraId property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    public void setParaId(Integer value) {
        this.paraId = value;
    }

    /**
     * Gets the value of the paraIdParent property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    public Integer getDurableId() {
        return durableId;
    }

    /**
     * Sets the value of the paraIdParent property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    public void setDurableId(Integer value) {
        this.durableId = value;
    }
}
