/*
/*
*
*    OPEN-XCHANGE legal information
*
*    All intellectual property rights in the Software are protected by
*    international copyright laws.
*
*
*    In some countries OX, OX Open-Xchange, open xchange and OXtender
*    as well as the corresponding Logos OX Open-Xchange and OX are registered
*    trademarks.
*    The use of the Logos is not covered by the GNU General Public License.
*    Instead, you are allowed to use these Logos according to the terms and
*    conditions of the Creative Commons License, Version 2.5, Attribution,
*    Non-commercial, ShareAlike, and the interpretation of the term
*    Non-commercial applicable to the aforementioned license is published
*    on the web site http://www.open-xchange.com/EN/legal/index.html.
*
*    Please make sure that third-party modules and libraries are used
*    according to their respective licenses.
*
*    Any modifications to this package must retain all copyright notices
*    of the original copyright holder(s) for the original code used.
*
*    After any such modifications, the original and derivative code shall remain
*    under the copyright of the copyright holder(s) and/or original author(s)per
*    the Attribution and Assignment Agreement that can be located at
*    http://www.open-xchange.com/EN/developer/. The contributing author shall be
*    given Attribution for the derivative code and a license granting use.
*
*     Copyright (C) 2016 OX Software GmbH
*     Mail: info@open-xchange.com
*
*
*     This program is free software; you can redistribute it and/or modify it
*     under the terms of the GNU General Public License, Version 2 as published
*     by the Free Software Foundation.
*
*     This program is distributed in the hope that it will be useful, but
*     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
*     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
*     for more details.
*
*     You should have received a copy of the GNU General Public License along
*     with this program; if not, write to the Free Software Foundation, Inc., 59
*     Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*/

package com.openexchange.office.documents.access.impl;

import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.office.document.api.Document;
import com.openexchange.office.document.api.DocumentDisposer;
import com.openexchange.office.document.api.FlushableDocument;
import com.openexchange.office.rt2.protocol.value.RT2CliendUidType;
import com.openexchange.office.rt2.protocol.value.RT2DocUidType;
import com.openexchange.office.tools.common.error.ErrorCode;
import com.openexchange.office.tools.doc.OXDocumentException;

@Service
public class DocumentRequestProcessor {
	
    private static final Logger log = LoggerFactory.getLogger(DocumentRequestProcessor.class);

    @Autowired
    private DocumentDisposer documentDisposer;

    //-------------------------------------------------------------------------
	public ManagedFile processDocRequest(RT2DocUidType docUid, RT2CliendUidType clientUid) throws OXException {
		ManagedFile result = null;

        try {
            result = handleFlushToManagedFile(docUid, clientUid);
        } catch (DocumentNotFoundException e) {
        	throw e;
        } catch (OXException e) {
            log.error(e.getMessage(), e);
            throw e;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new OXDocumentException("Exception caught while trying to process request", ErrorCode.GENERAL_UNKNOWN_ERROR);
        }

        return result;
	}

    //-------------------------------------------------------------------------
	private ManagedFile handleFlushToManagedFile(RT2DocUidType docUid, RT2CliendUidType clientUid) throws OXException, JSONException {
		ManagedFile result = null;

        final Document aDoc = documentDisposer.getDocument(docUid.getValue());
        final FlushableDocument aFlushableDoc = (aDoc instanceof FlushableDocument) ? (FlushableDocument)aDoc : null;

        if (null != aFlushableDoc) {
            try {
                final ManagedFile aManagedFile = aFlushableDoc.flushToManagedFile(clientUid);

                if (null != aManagedFile)
                    result = aManagedFile;
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
                throw new OXDocumentException("Exception caught while trying to process flushToManagedFile", ErrorCode.GENERAL_UNKNOWN_ERROR);
            }
        } else {
        	throw new DocumentNotFoundException();
        }

        return result;
	}
}
