/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.document.api;

import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.office.tools.common.error.ErrorCode;

/**
 * Provides information about an optional advisory
 * lock set on a document file.
 *
 * @author Carsten Driesner {carsten.driesner@open-xchange.com}
 * @since 7.10.5
 *
 */
public class AdvisoryLockInfo {
    public static final String ADVISORYLOCK_KEY = "oxDocAdvisoryLock";

    private static final String PROP_HOSTNAME = "hostName";
    private static final String PROP_CONTEXT_ID = "cid";
    private static final String PROP_USER_ID = "uid";
    private static final String PROP_SINCE = "since";

    private final String name;
    private final int contextId;
    private final int userId;
    private final String sinceDateTime;
    private ErrorCode errorCode = ErrorCode.NO_ERROR;
    private boolean advisoryLockWritten = false;

    public AdvisoryLockInfo(ErrorCode errorCode) {
        name = "";
        contextId = -1;
        userId = -1;
        sinceDateTime = "";
        this.errorCode = errorCode;
    }

    public AdvisoryLockInfo(String hostName, int contextId, int userId, String sinceDateTime) {
        this.name = hostName;
        this.contextId = contextId;
        this.userId = userId;
        this.sinceDateTime = sinceDateTime;
    }

    public AdvisoryLockInfo(JSONObject advisoryLockInfo) throws JSONException {
        name = advisoryLockInfo.getString(PROP_HOSTNAME);
        contextId = advisoryLockInfo.getInt(PROP_CONTEXT_ID);
        userId = advisoryLockInfo.getInt(PROP_USER_ID);
        sinceDateTime = advisoryLockInfo.getString(PROP_SINCE);
    }

    public JSONObject asJSONObject() throws JSONException {
        final JSONObject json = new JSONObject();
        json.put(PROP_HOSTNAME, this.name);
        json.put(PROP_CONTEXT_ID, this.contextId);
        json.put(PROP_USER_ID, this.userId);
        json.put(PROP_SINCE, sinceDateTime);
        return json;
    }

    public String getName() {
        return this.name;
    }

    public int getContextId() {
        return this.contextId;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getSinceDateTime() {
        return this.sinceDateTime;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public AdvisoryLockInfo setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public boolean getAdvisoryLockWritten() {
        return this.advisoryLockWritten;
    }

    public void setAdvisoryLockWritten(boolean written) {
        this.advisoryLockWritten = written;
    }

}
