/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.datasource.impl;

import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import com.openexchange.office.datasource.access.DataSourceAccess;
import com.openexchange.office.datasource.access.DataSourceException;
import com.openexchange.office.datasource.access.DataSourceResourceAccess;
import com.openexchange.office.datasource.access.MetaData;

public class DataSourceResourceAccessImpl implements DataSourceResourceAccess {

	private final DataSourceAccess dataSourceAccess;
	private final String folderId;
	private final String id;
	private final String versionOrAttachmentId;
	private final Optional<String> authCode;
	private AtomicReference<MetaData> cachedMetaData = new AtomicReference<>();

	public DataSourceResourceAccessImpl(DataSourceAccess dataSourceAccess, String folderId, String id, String versionOrAttachmentId, Optional<String> authCode) {
		this.dataSourceAccess = dataSourceAccess;
		this.folderId = folderId;
		this.id = id;
		this.versionOrAttachmentId = versionOrAttachmentId;
		this.authCode = authCode;
	}

	@Override
	public String getFolder() {
		return folderId;
	}

	@Override
	public String getId() {
		return id;
	}

	@Override
	public String getVersionOrAttachmentId() {
		return versionOrAttachmentId;
	}

	@Override
	public Optional<String> getAuthCode() {
		return authCode;
	}

	@Override
	public int getContextId() {
		return dataSourceAccess.getContextId();
	}

	@Override
	public boolean canRead() throws DataSourceException {
		return dataSourceAccess.canRead(folderId, id, versionOrAttachmentId);
	}

	@Override
	public MetaData getMetaData() throws DataSourceException {
		MetaData metaData = cachedMetaData.get();

		// use meta data cache for all data sources except drive where the content can
		// change
		if (null == metaData) {
			metaData = dataSourceAccess.getMetaData(folderId, id, versionOrAttachmentId, authCode);
			if (!(dataSourceAccess instanceof DataSourceAccessDrive)) {
				cachedMetaData.compareAndSet(null, metaData);
			}
		}

		return metaData;
	}

	@Override
	public InputStream getContentStream() throws DataSourceException {
		return dataSourceAccess.getContentStream(folderId, id, versionOrAttachmentId, authCode);
	}

}
