/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.broker;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.support.ExecutorChannelInterceptor;
import org.springframework.messaging.support.ExecutorSubscribableChannel;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.Assert;

class OrderedMessageSender
implements MessageChannel {
    static final String COMPLETION_TASK_HEADER = "simpSendCompletionTask";
    private final MessageChannel channel;
    private final Log logger;
    private final Queue<Message<?>> messages = new ConcurrentLinkedQueue();
    private final AtomicBoolean sendInProgress = new AtomicBoolean(false);

    public OrderedMessageSender(MessageChannel channel, Log logger) {
        this.channel = channel;
        this.logger = logger;
    }

    @Override
    public boolean send(Message<?> message) {
        return this.send(message, -1L);
    }

    @Override
    public boolean send(Message<?> message, long timeout) {
        this.messages.add(message);
        this.trySend();
        return true;
    }

    private void trySend() {
        if (this.messages.isEmpty()) {
            return;
        }
        if (this.sendInProgress.compareAndSet(false, true)) {
            this.sendNextMessage();
        }
    }

    private void sendNextMessage() {
        Message<?> message;
        while ((message = this.messages.poll()) != null) {
            try {
                this.addCompletionCallback(message);
                if (!this.channel.send(message)) continue;
                return;
            }
            catch (Throwable ex) {
                if (!this.logger.isErrorEnabled()) continue;
                this.logger.error("Failed to send " + message, ex);
            }
        }
        this.sendInProgress.set(false);
        this.trySend();
    }

    private void addCompletionCallback(Message<?> msg) {
        SimpMessageHeaderAccessor accessor = MessageHeaderAccessor.getAccessor(msg, SimpMessageHeaderAccessor.class);
        Assert.isTrue(accessor != null && accessor.isMutable(), "Expected mutable SimpMessageHeaderAccessor");
        accessor.setHeader(COMPLETION_TASK_HEADER, this::sendNextMessage);
    }

    static void configureOutboundChannel(MessageChannel channel, boolean preservePublishOrder) {
        if (preservePublishOrder) {
            Assert.isInstanceOf(ExecutorSubscribableChannel.class, (Object)channel, "An ExecutorSubscribableChannel is required for `preservePublishOrder`");
            ExecutorSubscribableChannel execChannel = (ExecutorSubscribableChannel)channel;
            if (execChannel.getInterceptors().stream().noneMatch(i -> i instanceof CallbackInterceptor)) {
                execChannel.addInterceptor(0, new CallbackInterceptor());
            }
        } else if (channel instanceof ExecutorSubscribableChannel) {
            ExecutorSubscribableChannel execChannel = (ExecutorSubscribableChannel)channel;
            execChannel.getInterceptors().stream().filter(i -> i instanceof CallbackInterceptor).findFirst().map(execChannel::removeInterceptor);
        }
    }

    private static class CallbackInterceptor
    implements ExecutorChannelInterceptor {
        private CallbackInterceptor() {
        }

        @Override
        public void afterMessageHandled(Message<?> msg, MessageChannel ch, MessageHandler handler, @Nullable Exception ex) {
            Runnable task = (Runnable)msg.getHeaders().get(OrderedMessageSender.COMPLETION_TASK_HEADER);
            if (task != null) {
                task.run();
            }
        }
    }
}

