/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import java.time.Duration;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.util.unit.DataSize;

public class JettyWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableJettyWebServerFactory>,
Ordered {
    private final Environment environment;
    private final ServerProperties serverProperties;

    public JettyWebServerFactoryCustomizer(Environment environment2, ServerProperties serverProperties) {
        this.environment = environment2;
        this.serverProperties = serverProperties;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void customize(ConfigurableJettyWebServerFactory factory) {
        ServerProperties properties = this.serverProperties;
        ServerProperties.Jetty jettyProperties = properties.getJetty();
        factory.setUseForwardHeaders(this.getOrDeduceUseForwardHeaders());
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from(jettyProperties::getAcceptors).whenNonNull().to(factory::setAcceptors);
        propertyMapper.from(jettyProperties::getSelectors).whenNonNull().to(factory::setSelectors);
        propertyMapper.from(properties::getMaxHttpHeaderSize).whenNonNull().asInt(DataSize::toBytes).when(this::isPositive).to(maxHttpHeaderSize -> factory.addServerCustomizers(new MaxHttpHeaderSizeCustomizer((int)maxHttpHeaderSize)));
        propertyMapper.from(jettyProperties::getMaxHttpFormPostSize).asInt(DataSize::toBytes).when(this::isPositive).to(maxHttpFormPostSize -> this.customizeMaxHttpFormPostSize(factory, (int)maxHttpFormPostSize));
        propertyMapper.from(jettyProperties::getMaxThreads).when(this::isPositive).to(maxThreads -> this.customizeThreadPool(factory, threadPool -> threadPool.setMaxThreads(maxThreads.intValue())));
        propertyMapper.from(jettyProperties::getMinThreads).when(this::isPositive).to(minThreads -> this.customizeThreadPool(factory, threadPool -> threadPool.setMinThreads(minThreads.intValue())));
        propertyMapper.from(jettyProperties::getThreadIdleTimeout).whenNonNull().asInt(Duration::toMillis).to(idleTimeout -> this.customizeThreadPool(factory, threadPool -> threadPool.setIdleTimeout(idleTimeout.intValue())));
        propertyMapper.from(properties::getConnectionTimeout).whenNonNull().to(connectionTimeout -> this.customizeIdleTimeout(factory, (Duration)connectionTimeout));
        propertyMapper.from(jettyProperties::getConnectionIdleTimeout).whenNonNull().to(idleTimeout -> this.customizeIdleTimeout(factory, (Duration)idleTimeout));
        propertyMapper.from(jettyProperties::getAccesslog).when(ServerProperties.Jetty.Accesslog::isEnabled).to(accesslog -> this.customizeAccessLog(factory, (ServerProperties.Jetty.Accesslog)accesslog));
    }

    private boolean isPositive(Integer value) {
        return value > 0;
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.getForwardHeadersStrategy().equals((Object)ServerProperties.ForwardHeadersStrategy.NONE)) {
            CloudPlatform platform = CloudPlatform.getActive(this.environment);
            return platform != null && platform.isUsingForwardHeaders();
        }
        return this.serverProperties.getForwardHeadersStrategy().equals((Object)ServerProperties.ForwardHeadersStrategy.NATIVE);
    }

    private void customizeIdleTimeout(ConfigurableJettyWebServerFactory factory, Duration connectionTimeout) {
        factory.addServerCustomizers(server -> {
            for (Connector connector : server.getConnectors()) {
                if (!(connector instanceof AbstractConnector)) continue;
                ((AbstractConnector)connector).setIdleTimeout(connectionTimeout.toMillis());
            }
        });
    }

    private void customizeMaxHttpFormPostSize(ConfigurableJettyWebServerFactory factory, final int maxHttpFormPostSize) {
        factory.addServerCustomizers(new JettyServerCustomizer(){

            @Override
            public void customize(Server server) {
                this.setHandlerMaxHttpFormPostSize(server.getHandlers());
            }

            private void setHandlerMaxHttpFormPostSize(Handler ... handlers) {
                for (Handler handler : handlers) {
                    if (handler instanceof ContextHandler) {
                        ((ContextHandler)handler).setMaxFormContentSize(maxHttpFormPostSize);
                        continue;
                    }
                    if (handler instanceof HandlerWrapper) {
                        this.setHandlerMaxHttpFormPostSize(((HandlerWrapper)handler).getHandler());
                        continue;
                    }
                    if (!(handler instanceof HandlerCollection)) continue;
                    this.setHandlerMaxHttpFormPostSize(((HandlerCollection)handler).getHandlers());
                }
            }
        });
    }

    private void customizeThreadPool(ConfigurableJettyWebServerFactory factory, Consumer<QueuedThreadPool> customizer2) {
        factory.addServerCustomizers(connector -> {
            ThreadPool threadPool = connector.getThreadPool();
            if (threadPool instanceof QueuedThreadPool) {
                customizer2.accept((QueuedThreadPool)threadPool);
            }
        });
    }

    private void customizeAccessLog(ConfigurableJettyWebServerFactory factory, ServerProperties.Jetty.Accesslog properties) {
        factory.addServerCustomizers(server -> {
            RequestLogWriter logWriter = new RequestLogWriter();
            String format = this.getLogFormat(properties);
            CustomRequestLog log = new CustomRequestLog((RequestLog.Writer)logWriter, format);
            if (!CollectionUtils.isEmpty(properties.getIgnorePaths())) {
                log.setIgnorePaths(properties.getIgnorePaths().toArray(new String[0]));
            }
            if (properties.getFilename() != null) {
                logWriter.setFilename(properties.getFilename());
            }
            if (properties.getFileDateFormat() != null) {
                logWriter.setFilenameDateFormat(properties.getFileDateFormat());
            }
            logWriter.setRetainDays(properties.getRetentionPeriod());
            logWriter.setAppend(properties.isAppend());
            server.setRequestLog((RequestLog)log);
        });
    }

    private String getLogFormat(ServerProperties.Jetty.Accesslog properties) {
        if (properties.getCustomFormat() != null) {
            return properties.getCustomFormat();
        }
        if (ServerProperties.Jetty.Accesslog.FORMAT.EXTENDED_NCSA.equals((Object)properties.getFormat())) {
            return "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"";
        }
        return "%{client}a - %u %t \"%r\" %s %O";
    }

    private static class MaxHttpHeaderSizeCustomizer
    implements JettyServerCustomizer {
        private final int maxHttpHeaderSize;

        MaxHttpHeaderSizeCustomizer(int maxHttpHeaderSize) {
            this.maxHttpHeaderSize = maxHttpHeaderSize;
        }

        @Override
        public void customize(Server server) {
            Arrays.stream(server.getConnectors()).forEach(this::customize);
        }

        private void customize(Connector connector) {
            connector.getConnectionFactories().forEach(this::customize);
        }

        private void customize(ConnectionFactory factory) {
            if (factory instanceof HttpConfiguration.ConnectionFactory) {
                ((HttpConfiguration.ConnectionFactory)factory).getHttpConfiguration().setRequestHeaderSize(this.maxHttpHeaderSize);
            }
        }
    }
}

