/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms.artemis;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.jms.artemis.ArtemisMode;
import org.springframework.boot.autoconfigure.jms.artemis.ArtemisProperties;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class ArtemisConnectionFactoryFactory {
    static final String[] EMBEDDED_JMS_CLASSES = new String[]{"org.apache.activemq.artemis.jms.server.embedded.EmbeddedJMS", "org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ"};
    private final ArtemisProperties properties;
    private final ListableBeanFactory beanFactory;

    ArtemisConnectionFactoryFactory(ListableBeanFactory beanFactory, ArtemisProperties properties) {
        Assert.notNull((Object)beanFactory, "BeanFactory must not be null");
        Assert.notNull((Object)properties, "Properties must not be null");
        this.beanFactory = beanFactory;
        this.properties = properties;
    }

    <T extends ActiveMQConnectionFactory> T createConnectionFactory(Class<T> factoryClass) {
        try {
            this.startEmbeddedJms();
            return this.doCreateConnectionFactory(factoryClass);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create ActiveMQConnectionFactory", ex);
        }
    }

    private void startEmbeddedJms() {
        for (int i = 0; i < EMBEDDED_JMS_CLASSES.length; ++i) {
            if (!ClassUtils.isPresent(EMBEDDED_JMS_CLASSES[i], null)) continue;
            try {
                this.beanFactory.getBeansOfType(Class.forName(EMBEDDED_JMS_CLASSES[i]));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private <T extends ActiveMQConnectionFactory> T doCreateConnectionFactory(Class<T> factoryClass) throws Exception {
        ArtemisMode mode = this.properties.getMode();
        if (mode == null) {
            mode = this.deduceMode();
        }
        if (mode == ArtemisMode.EMBEDDED) {
            return this.createEmbeddedConnectionFactory(factoryClass);
        }
        return this.createNativeConnectionFactory(factoryClass);
    }

    private ArtemisMode deduceMode() {
        if (this.properties.getEmbedded().isEnabled() && this.isEmbeddedJmsClassPresent()) {
            return ArtemisMode.EMBEDDED;
        }
        return ArtemisMode.NATIVE;
    }

    private boolean isEmbeddedJmsClassPresent() {
        for (int i = 0; i < EMBEDDED_JMS_CLASSES.length; ++i) {
            if (!ClassUtils.isPresent(EMBEDDED_JMS_CLASSES[i], null)) continue;
            return true;
        }
        return false;
    }

    private <T extends ActiveMQConnectionFactory> T createEmbeddedConnectionFactory(Class<T> factoryClass) throws Exception {
        try {
            TransportConfiguration transportConfiguration = new TransportConfiguration(InVMConnectorFactory.class.getName(), this.properties.getEmbedded().generateTransportParameters());
            ServerLocator serviceLocator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{transportConfiguration});
            return (T)((ActiveMQConnectionFactory)factoryClass.getConstructor(ServerLocator.class).newInstance(serviceLocator));
        }
        catch (NoClassDefFoundError ex) {
            throw new IllegalStateException("Unable to create InVM Artemis connection, ensure that artemis-jms-server.jar is in the classpath", ex);
        }
    }

    private <T extends ActiveMQConnectionFactory> T createNativeConnectionFactory(Class<T> factoryClass) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("host", this.properties.getHost());
        params.put("port", this.properties.getPort());
        TransportConfiguration transportConfiguration = new TransportConfiguration(NettyConnectorFactory.class.getName(), params);
        Constructor<T> constructor = factoryClass.getConstructor(Boolean.TYPE, TransportConfiguration[].class);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)constructor.newInstance(false, new TransportConfiguration[]{transportConfiguration});
        String user = this.properties.getUser();
        if (StringUtils.hasText(user)) {
            connectionFactory.setUser(user);
            connectionFactory.setPassword(this.properties.getPassword());
        }
        return (T)connectionFactory;
    }
}

