/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.classchecks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.hibernate.validator.ap.internal.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.internal.classchecks.AbstractMethodOverrideCheck;
import org.hibernate.validator.ap.internal.classchecks.MethodInheritanceTree;
import org.hibernate.validator.ap.internal.util.CollectionHelper;
import org.hibernate.validator.ap.internal.util.ConstraintHelper;
import org.hibernate.validator.ap.internal.util.StringHelper;

public class ParametersMethodOverrideCheck
extends AbstractMethodOverrideCheck {
    public ParametersMethodOverrideCheck(Elements elementUtils, Types typeUtils, ConstraintHelper constraintHelper) {
        super(elementUtils, typeUtils, constraintHelper);
    }

    @Override
    protected Set<ConstraintCheckIssue> checkMethodInternal(ExecutableElement currentMethod, MethodInheritanceTree methodInheritanceTree) {
        if (methodInheritanceTree.hasParallelDefinitions()) {
            HashSet<ConstraintCheckIssue> issues = CollectionHelper.newHashSet();
            for (ExecutableElement method : methodInheritanceTree.getAllMethods()) {
                if (!this.hasAnnotationsOnParameters(method)) continue;
                issues.add(ConstraintCheckIssue.error(currentMethod, null, "INCORRECT_METHOD_PARAMETERS_PARALLEL_IMPLEMENTATION_OVERRIDING", this.getEnclosingTypeElementQualifiedNames(methodInheritanceTree.getTopLevelMethods())));
            }
            if (!issues.isEmpty()) {
                return issues;
            }
        }
        if (this.hasAnnotationsOnParameters(currentMethod)) {
            Set<ExecutableElement> overriddenMethods = methodInheritanceTree.getOverriddenMethods();
            return CollectionHelper.asSet(ConstraintCheckIssue.error(currentMethod, null, "INCORRECT_METHOD_PARAMETERS_OVERRIDING", this.getEnclosingTypeElementQualifiedNames(overriddenMethods)));
        }
        return Collections.emptySet();
    }

    @Override
    protected boolean needToPerformAnyChecks(ExecutableElement currentMethod) {
        return !currentMethod.getParameters().isEmpty();
    }

    private boolean hasAnnotationsOnParameters(ExecutableElement method) {
        for (VariableElement variableElement : method.getParameters()) {
            for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                ConstraintHelper.AnnotationType annotationType = this.constraintHelper.getAnnotationType(annotationMirror);
                if (!ConstraintHelper.AnnotationType.CONSTRAINT_ANNOTATION.equals((Object)annotationType) && !ConstraintHelper.AnnotationType.MULTI_VALUED_CONSTRAINT_ANNOTATION.equals((Object)annotationType) && !ConstraintHelper.AnnotationType.GRAPH_VALIDATION_ANNOTATION.equals((Object)annotationType)) continue;
                return true;
            }
        }
        return false;
    }

    private String getEnclosingTypeElementQualifiedNames(Set<ExecutableElement> methods) {
        ArrayList enclosingTypeElementQualifiedNames = CollectionHelper.newArrayList();
        for (ExecutableElement method : methods) {
            enclosingTypeElementQualifiedNames.add(this.getEnclosingTypeElementQualifiedName(method));
        }
        Collections.sort(enclosingTypeElementQualifiedNames);
        return StringHelper.join(enclosingTypeElementQualifiedNames, ", ");
    }
}

