package com.openexchange.office.tools.service.validation.validator.tools;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.leangen.geantyref.AnnotationFormatException;
import io.leangen.geantyref.TypeFactory;

public class AnnotationCopier {
	
	private static final Logger log = LoggerFactory.getLogger(AnnotationCopier.class);
	
	private static Set<String> basicMethods = new HashSet<>();
	
	static {
		for (Method m : Annotation.class.getDeclaredMethods()) {
			basicMethods.add(m.getName());
		}
		for (Method m : Object.class.getDeclaredMethods()) {
			basicMethods.add(m.getName());
		}		
	}
	
	public static <S extends Annotation, T extends Annotation> T copyAnnotation(S sourceAnno, Class<S> sourceClass, Class<T> targetClass) {
		Method [] methods = sourceAnno.getClass().getMethods();
		Map<String, Object> params = new HashMap<>();
		for (Method method : methods) {
			if (method.isSynthetic()) {
				continue;
			}
			if (method.getParameterCount() > 0) {
				continue;
			}
			if (basicMethods.contains(method.getName())) {
				continue;
			}
			try {
				params.put(method.getName(), method.invoke(sourceAnno));
			} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
				log.error(e.getMessage(), e);
				throw new RuntimeException(e);
			}			
		}		
		try {
			T res = TypeFactory.annotation(targetClass, params);
			return res;
		} catch (AnnotationFormatException e) {
			log.error(e.getMessage(), e);
			throw new RuntimeException(e);			
		}				
	}
	
	private AnnotationCopier() {}
}
