package com.openexchange.office.tools.service.storage.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.office.tools.annotation.RegisteredService;
import com.openexchange.office.tools.service.config.UserConfigurationFactory;
import com.openexchange.office.tools.service.storage.StorageHelperService;
import com.openexchange.office.tools.service.storage.StorageHelperServiceFactory;
import com.openexchange.session.Session;

@Service
@RegisteredService(registeredClass=StorageHelperServiceFactory.class)
public class StorageHelperServiceFactoryImpl implements StorageHelperServiceFactory {

	@Autowired
	private IDBasedFileAccessFactory idBasedFileAccessFactory;
	
	@Autowired
	private UserConfigurationFactory userConfigurationFactory;
	
	@Override
	public StorageHelperService create(Session session, String folderId) {
		return new StorageHelperServiceImpl(idBasedFileAccessFactory, userConfigurationFactory, session, folderId);
	}

}
