package com.openexchange.office.tools.service.http;

import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

import com.google.common.reflect.TypeToken;
import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionConstants;
import com.openexchange.office.tools.common.error.ErrorCode;
import com.openexchange.office.tools.common.error.ExceptionToErrorCode;
import com.openexchange.office.tools.common.error.HttpStatusCode;
import com.openexchange.office.tools.service.conversion.ConversionException;
import com.openexchange.office.tools.service.conversion.OfficeConverter;
import com.openexchange.office.tools.service.conversion.RequestDataIsNullException;
import com.openexchange.office.tools.service.validation.OfficeValidator;
import com.openexchange.tools.session.ServerSession;

public abstract class AjaxActionServiceWithConcreteModel<T> implements AJAXActionService {

	@Autowired
	private OfficeConverter converter;
	
	@Autowired
	private OfficeValidator validator;
	
	@SuppressWarnings("serial")
	private TypeToken<T> ajaxRequestModelTT = new TypeToken<T>(getClass()) {};

	@Override
	public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        if ((null == session) || (session.isAnonymous())) {
    		AJAXRequestResult res = new AJAXRequestResult();
    		res.setHttpStatusCode(HttpStatusCode.UNAUTHORIZED.getStatusCode());
    		return res;
        }		
		Class<? super T> resultClass = ajaxRequestModelTT.getRawType();
		try {
			@SuppressWarnings("unchecked")
			T concreteModel = (T) resultClass.cast(converter.convert(requestData, ajaxRequestModelTT.getRawType()));
			String validationRes = validator.validate(concreteModel);
			if (validationRes != null) {
				JSONObject jsonResult = new JSONObject();
				ErrorCode errorCode = ExceptionToErrorCode.map(new OXException(OXExceptionConstants.CODE_DEFAULT, validationRes), ErrorCode.GENERAL_ARGUMENTS_ERROR, false);
				ErrorCode errorCode2 = new ErrorCode(errorCode.getCode(), errorCode.getCodeAsStringConstant(), validationRes, errorCode.getErrorClass());
				try {jsonResult.put("error", errorCode2.getAsJSON()); } catch (final JSONException je) { /* ignore it */ }
				return new AJAXRequestResult(jsonResult);
			}
			return perform(concreteModel,requestData, session);
		} catch (RequestDataIsNullException ex) {
			JSONObject jsonResult = new JSONObject();
            ErrorCode errorCode = ExceptionToErrorCode.map(new OXException(OXExceptionConstants.CODE_DEFAULT, ex.getMessage()), ErrorCode.GENERAL_ARGUMENTS_ERROR, false);
            try {jsonResult.put("error", errorCode.getAsJSON()); } catch (final JSONException je) { /* ignore it */ }
            return new AJAXRequestResult(jsonResult);			 
		} catch (ConversionException ex) {
			JSONObject jsonResult = new JSONObject();
            ErrorCode errorCode = ExceptionToErrorCode.map(new OXException(OXExceptionConstants.CODE_DEFAULT, ex.getMessage()), ErrorCode.GENERAL_UNKNOWN_ERROR, false);
            try {jsonResult.put("error", errorCode.getAsJSON()); } catch (final JSONException je) { /* ignore it */ }
            return new AJAXRequestResult(jsonResult);			
		}		
	}
	
	protected AJAXRequestResult perform(T requestModel, AJAXRequestData requestData, ServerSession session) throws OXException {
		AJAXRequestResult res = new AJAXRequestResult();
		res.setHttpStatusCode(HttpStatusCode.OK.getStatusCode());
		return res;
	}
}
