/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.tools.service.config;

import org.json.JSONArray;
import org.json.JSONObject;

public interface UserConfigurationHelper {

	public enum Mode {
		WRITE_THROUGH,
		WRITE_BACK
	}

	public JSONObject getJSONObject(String path);
	public JSONArray getJSONArray(String path);
	public String getString(String path);
	public String getString(String path, String defaultValue);
	public Double getDouble(String path);
    public Double getDouble(String path, Double defaultValue);
	public Long getLong(String path);
    public Long getLong(String path, Long defaultValue);
	public Integer getInteger(String path);
    public Integer getInteger(String path, Integer defaultValue);
	public Boolean getBoolean(String path);
    public Boolean getBoolean(String path, Boolean defaultValue);
	public boolean setValue(String path, Boolean value);
    public boolean setValue(String path, String value);
    public boolean setValue(String path, Integer value);
    public boolean setValue(String path, Long value);
    public boolean setValue(String path, Double value);
    public boolean setValue(String path, JSONObject value);
    public boolean setValue(String path, JSONArray value);
    public boolean refreshCache();
    public boolean flushCache();

}
