package com.openexchange.office.tools.service.caching;

import java.util.UUID;

import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

import com.hazelcast.core.HazelcastInstance;

public class HazelcastUuidHelper {

	public static final String HAZELCAST_UUID = "HAZELCAST_UUID";
	
	private static String nodeUuid;
	
	public static UUID getNodeUuid() {
		return UUID.fromString(getNodeUuidAsStr());
	}
	
	public static String getNodeUuidAsStr() {
		if (StringUtils.isBlank(nodeUuid)) {
			if (StringUtils.isNotBlank(System.getProperty(HAZELCAST_UUID))) {
				nodeUuid = System.getProperty(HAZELCAST_UUID);
			} else {
				final Bundle aBundle = FrameworkUtil.getBundle(HazelcastInstance.class);
				final BundleContext aBundleContext = aBundle.getBundleContext();
				HazelcastInstance res = aBundleContext.getService(aBundleContext.getServiceReference(HazelcastInstance.class));
				if (res == null) {
					throw new IllegalStateException("HazelcastInstance not found! It is impossible to get hazelcast uuid then.");
				}
				nodeUuid = res.getCluster().getLocalMember().getUuid();
			}
		}		
		return nodeUuid;
	}
	
	
	private HazelcastUuidHelper() {}
}
