package com.openexchange.office.tools.jms;

import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;

public class OfficeJmsDestination {
    public static final String REQUEST_DOC_TOPIC_STR = "requestDoc-Topic";
	public static final String RESPONSE_DOC_TOPIC_STR = "responseDoc-queue-";
	
	public static final ActiveMQTopic requestDocTopic = new ActiveMQTopic(REQUEST_DOC_TOPIC_STR);
	
	public static ActiveMQQueue getResponseDocQueue(String nodeUuid) {
		return new ActiveMQQueue(RESPONSE_DOC_TOPIC_STR + nodeUuid);
	}
	
	private OfficeJmsDestination() {}
}
