package com.openexchange.office.tools.jms;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.openexchange.config.ConfigurationService;
import com.openexchange.office.tools.annotation.RegisteredService;

@Service
@RegisteredService
public class JmsConfigService {

    public static final String KEY_JMS_USERNAME = "com.openexchange.dcs.client.username";
    public static final String JMS_USERNAME_DEFAULT = "";
    
    public static final String KEY_JMS_PASSWORD = "com.openexchange.dcs.client.password";
    public static final String JMS_PASSWORD_DEFAULT = ""; 
    
    public static final String JMS_KEY_SSL_VERIFY_HOSTNAME = "com.openexchange.dcs.client.ssl.verifyHostname";

    public static final String KEY_JMS_SSL_KEYSTORE_PATH = "com.openexchange.dcs.client.ssl.keystore.path";
    public static final String JMS_SSL_KEYSTORE_PATH_DEFAULT = "/opt/open-xchange/etc/security/documents-collaboration-client.ks";

    public static final String KEY_JMS_SSL_KEYSTORE_PASSWORD = "com.openexchange.dcs.client.ssl.keystore.password";
    public static final String JMS_SSL_KEYSTORE_PASSWORD_DEFAULT = "password";

    public static final String KEY_JMS_SSL_TRUSTSTORE_PATH = "com.openexchange.dcs.client.ssl.truststore.path";
    public static final String JMS_SSL_TRUSTSTORE_PATH_DEFAULT = "/opt/open-xchange/etc/security/documents-collaboration-client.ts";

    public static final String KEY_JMS_SSL_TRUSTSTORE_PASSWORD = "com.openexchange.dcs.client.ssl.truststore.password";
    public static final String JMS_SSL_TRUSTSTORE_PASSWORD_DEFAULT = "password";

    @Autowired
    private ConfigurationService configurationService;    
    
    //-------------------------------------------------------------------------
    public boolean isRT2SSLVerifyHostname() {
        return configurationService.getBoolProperty(JMS_KEY_SSL_VERIFY_HOSTNAME, false);
    }

    //-------------------------------------------------------------------------
    public String getRT2SSLKeystorePath() {
        final String sID = configurationService.getProperty(KEY_JMS_SSL_KEYSTORE_PATH);
        return StringUtils.isBlank(sID) ? JMS_SSL_KEYSTORE_PATH_DEFAULT : sID;
    }

    //-------------------------------------------------------------------------
    public String getRT2SSLKeystorePassword() {
        final String sID = configurationService.getProperty(KEY_JMS_SSL_KEYSTORE_PASSWORD);
        return StringUtils.isBlank(sID) ? JMS_SSL_KEYSTORE_PASSWORD_DEFAULT : sID;
    }

    //-------------------------------------------------------------------------
    public String getRT2SSLTrustStorePath() {
        final String sID = configurationService.getProperty(KEY_JMS_SSL_TRUSTSTORE_PATH);
        return StringUtils.isBlank(sID) ? JMS_SSL_TRUSTSTORE_PATH_DEFAULT : sID;
    }

    //-------------------------------------------------------------------------
    public String getRT2SSLTrustStorePassword() {
        final String sID = configurationService.getProperty(KEY_JMS_SSL_TRUSTSTORE_PASSWORD);
        return StringUtils.isBlank(sID) ? JMS_SSL_TRUSTSTORE_PASSWORD_DEFAULT : sID;
    }

    //-------------------------------------------------------------------------
    public String getJmsUsername() {
        final String sID = configurationService.getProperty(KEY_JMS_USERNAME);
        return StringUtils.isBlank(sID) ? JMS_USERNAME_DEFAULT : sID;
    }

    //-------------------------------------------------------------------------
    public String getJmsPassword() {
        final String sID = configurationService.getProperty(KEY_JMS_PASSWORD);
        return StringUtils.isBlank(sID) ? JMS_PASSWORD_DEFAULT : sID;
    }    
}
