/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.tools.database;

import java.util.Properties;

/**
 * {@link DatabaseConnectionData}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 * @since v7.10.1
 */
public interface DatabaseConnectionData {

    /**
     * DEFAULT_DRIVER_CLASS
     */
    String DEFAULT_DRIVER_CLASSNAME = "com.mysql.jdbc.Driver";

    /**
     * DEFAULT_CONNECT_TIMEOUT_MILLIS
     */
    int DEFAULT_CONNECT_TIMEOUT_MILLIS = 60000;

    /**
     * DEFAULT_SOCKET_TIMEOUT_MILLIS
     */
    int DEFAULT_SOCKET_TIMEOUT_MILLIS = 60000;

    /**
     * @return The driver class for the database connection to be used.
     */
    default String getDriverClassName() {
        return DEFAULT_DRIVER_CLASSNAME;
    }

    /**
     * @return The URL for the database connection to be used.
     */
    String getConnectionURL();

    /**
     * @return The database username for the connection.
     */
    String getUserName();

    /**
     * @return The database password for the connection.
     */
    String getPassword();

    /**
     * @return Database specific JDBC {@link Properties}, containing
     *  {@link String} keys and {@link String}/{@link Boolean}/{@link Integer}
     *  object values throughout.
     */
    default Properties getJDBCProperties() {
        final Properties defaultDatabaseProperties = new Properties();

        defaultDatabaseProperties.put("useUnicode", "true");
        defaultDatabaseProperties.put("characterEncoding", "UTF-8");
        defaultDatabaseProperties.put("autoReconnect", "false");
        defaultDatabaseProperties.put("useServerPrepStmts", "true");
        defaultDatabaseProperties.put("useTimezone", "true");
        defaultDatabaseProperties.put("serverTimezone", "UTC");
        defaultDatabaseProperties.put("connectTimeout", Integer.valueOf(DEFAULT_CONNECT_TIMEOUT_MILLIS).toString());
        defaultDatabaseProperties.put("socketTimeout", Integer.valueOf(DEFAULT_SOCKET_TIMEOUT_MILLIS).toString());
        defaultDatabaseProperties.put("prepStmtCacheSize", Integer.valueOf(250).toString());
        defaultDatabaseProperties.put("prepStmtCacheSqlLimit", Integer.valueOf(4096).toString());
        defaultDatabaseProperties.put("cachePrepStmts", "true");
        defaultDatabaseProperties.put("useSSL", "false");
        defaultDatabaseProperties.put("requireSSL", "false");
        defaultDatabaseProperties.put("verifyServerCertificate", "false");
        defaultDatabaseProperties.put("enabledTLSProtocols", "TLSv1,TLSv1.1,TLSv1.2");
        defaultDatabaseProperties.put("clientCertificateKeyStoreUrl", "");
        defaultDatabaseProperties.put("clientCertificateKeyStoreType", "");
        defaultDatabaseProperties.put("clientCertificateKeyStorePassword", "");
        defaultDatabaseProperties.put("trustCertificateKeyStoreUrl", "");
        defaultDatabaseProperties.put("trustCertificateKeyStoreType", "");
        defaultDatabaseProperties.put("trustCertificateKeyStorePassword", "");

        return defaultDatabaseProperties;
    }

}
