package com.openexchange.office.tools.common.exception;

import java.text.MessageFormat;

public class ValueNotFoundException extends RuntimeException {

	public static final MessageFormat ERROR_MSG_FMT = new MessageFormat("Value with name {0} not found in configuration!");
	
	private static final long serialVersionUID = -8539676770295578107L;

	public ValueNotFoundException(String valueName) {
		super(ERROR_MSG_FMT.format(new Object [] {valueName}));
	}
}
