package com.openexchange.office.tools.common.exception;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleNotStartedException extends RuntimeException {

	private static final Logger log = LoggerFactory.getLogger(BundleNotStartedException.class);
	
	private static final long serialVersionUID = 3018827034895086996L;

	public BundleNotStartedException(String bundleId) {
		super("Bundle '" + bundleId + "' has not been started yet!");
		log.error("Bundle '" + bundleId + "' has not been started yet!");		
	}
}
