package com.openexchange.office.tools.common.error;


/**
 * A helper class to map certain error codes to specific error codes
 * that are used by the backup file processing.
 *
 * {@link ErrorCode}
 *
 * @author <a href="mailto:carsten.driesner@open-xchange.com">Carsten Driesner</a>
 */
public class ErrorCode2BackupErrorCode
{
    /**
     * Maps certain general error codes to specific backup file error codes.
     *
     * @param errorCode
     *  The original error code.
     *
     * @param defErrorCode
     *  A default error code to be used, if no defined mapping can be found.
     *
     * @return
     *  A mapped or the default error code to be used by the backup handling
     *  code.
     */
    public static ErrorCode mapToBackupErrorCode(final ErrorCode errorCode, final ErrorCode defErrorCode) {
        ErrorCode result = defErrorCode;
        int code = errorCode.getCode();

        if (code == ErrorCode.CODE_NO_ERROR) // no error must be mapped, too
            result = errorCode;
        else if (code == ErrorCode.GENERAL_FILE_NOT_FOUND_ERROR.getCode())
            result = ErrorCode.SAVEDOCUMENT_BACKUPFILE_CREATE_FAILED_ERROR;
        else if (code == ErrorCode.GENERAL_PERMISSION_CREATE_MISSING_ERROR.getCode())
            result = ErrorCode.SAVEDOCUMENT_BACKUPFILE_CREATE_PERMISSION_MISSING_ERROR;
        else if ((code == ErrorCode.GENERAL_PERMISSION_READ_MISSING_ERROR.getCode()) ||
                 (code == ErrorCode.GENERAL_PERMISSION_WRITE_MISSING_ERROR.getCode()))
            result = ErrorCode.SAVEDOCUMENT_BACKUPFILE_READ_OR_WRITE_PERMISSION_MISSING_ERROR;
        else if (code == ErrorCode.GENERAL_QUOTA_REACHED_ERROR.getCode())
            result = ErrorCode.SAVEDOCUMENT_BACKUPFILE_QUOTA_REACHED_ERROR;

        return result;
    }
}
