package com.openexchange.office.rt2.core.proxy;

import org.springframework.stereotype.Service;

import com.openexchange.office.rt2.protocol.RT2Message;
import com.openexchange.office.rt2.protocol.value.RT2CliendUidType;
import com.openexchange.office.rt2.protocol.value.RT2DocUidType;

@Service
public class RT2DocProxyStateHolderFactory {
	public RT2DocProxyStateHolder createDocProxyStateHolder(RT2CliendUidType clientUid, RT2DocUidType docUid) {
		return new RT2DocProxyStateHolder(clientUid, docUid);
	}

	public RT2DocProxyStateHolder createDocProxyStateHolder(RT2Message msg) {
		return new RT2DocProxyStateHolder(msg.getClientUID(), msg.getDocUID());
	}	
}
