package com.openexchange.office.rt2.core.logging;

import java.util.Collection;
import java.util.List;

import org.apache.commons.text.TextStringBuilder;
import org.slf4j.Logger;

import com.openexchange.log.LogProperties;
import com.openexchange.office.rt2.protocol.value.RT2CliendUidType;
import com.openexchange.office.rt2.protocol.value.RT2DocUidType;

public class MessagesLogger implements Runnable {

	private final IMessagesObjectManager msgsObjectMgr;
	
	private final Logger logger;
	
	public MessagesLogger(IMessagesObjectManager msgsObjectMgr, Logger logger) {
		this.msgsObjectMgr = msgsObjectMgr;
		this.logger = logger;
	}

	@Override
	public void run() {
		Collection<IMessagesLoggable> loggableCol = msgsObjectMgr.getManagedCollection();
		for (IMessagesLoggable loggableObj : loggableCol) {
			 List<String> loggList = loggableObj.formatMsgsLogInfo();
			 RT2CliendUidType clientUid = loggableObj.getClientUID();
			 RT2DocUidType docUid = loggableObj.getDocUID();
			 StringBuilder strBuilder = new StringBuilder();
             LogProperties.putProperty(LogProperties.Name.RT2_DOC_UID, docUid.getValue());
             LogProperties.putProperty(LogProperties.Name.RT2_BACKEND_PART, "MessagesLogger");
			 if (clientUid == null) {				 
				 strBuilder.append("Current messages of DocProcessor with docUid '");
				 strBuilder.append(docUid);
				 
			 } else {
				 LogProperties.putProperty(LogProperties.Name.RT2_CLIENT_UID, clientUid.getValue());
				 strBuilder.append("Current messages of DocProxy with docUid '");
				 strBuilder.append(docUid);
				 strBuilder.append("' and clientUid '");
				 strBuilder.append(clientUid);
			 }
			 strBuilder.append("': ");
		     TextStringBuilder builder = new TextStringBuilder(loggList.get(0));
		     loggList.remove(0);
		     loggList.forEach(s -> builder.appendln("    " + s));		    	
			 strBuilder.append(loggList);			 
			 logger.debug(strBuilder.toString());
			 LogProperties.removeLogProperties();
			 try {
				Thread.sleep(100);
			} catch (InterruptedException e) {
			}
		}
	}
}
