package com.openexchange.office.rt2.core.exception;

import java.util.List;

import com.openexchange.office.rt2.core.RT2LogInfo;
import com.openexchange.office.rt2.protocol.value.RT2DocUidType;
import com.openexchange.office.tools.common.error.ErrorCode;

public class RT2InvalidDocumentIdentifierException extends RT2TypedException {

	private static final long serialVersionUID = -914963728005333305L;

	public RT2InvalidDocumentIdentifierException(RT2DocUidType docUid, List<RT2LogInfo> msgs) {
		super(ErrorCode.GENERAL_DOCUMENT_ALREADY_DISPOSED_ERROR, msgs, "docUid", docUid.getValue());
	}
}
