/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.rt2.core.doc;

import com.openexchange.office.rt2.protocol.value.RT2CliendUidType;

public class DocProcessorClientInfo
{
	//-------------------------------------------------------------------------
	private final String sNodeUUID;

	//-------------------------------------------------------------------------
	private final RT2CliendUidType sClientUID;

	//-------------------------------------------------------------------------
	public DocProcessorClientInfo(RT2CliendUidType sClientUID, String sNodeUUID) {
		this.sClientUID = sClientUID;
		this.sNodeUUID  = sNodeUUID;
	}

	//-------------------------------------------------------------------------
	public RT2CliendUidType getClientUID() { return sClientUID; }

	//-------------------------------------------------------------------------
	public String getNodeUUID() { return sNodeUUID; }

    @Override
    public String toString() {
        return "ClientInfo [sNodeUUID=" + sNodeUUID + ", sClientUID=" + sClientUID + "]";
    }

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((sClientUID == null) ? 0 : sClientUID.hashCode());
		result = prime * result + ((sNodeUUID == null) ? 0 : sNodeUUID.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		DocProcessorClientInfo other = (DocProcessorClientInfo) obj;
		if (sClientUID == null) {
			if (other.sClientUID != null)
				return false;
		} else if (!sClientUID.equals(other.sClientUID))
			return false;
		if (sNodeUUID == null) {
			if (other.sNodeUUID != null)
				return false;
		} else if (!sNodeUUID.equals(other.sNodeUUID))
			return false;
		return true;
	}
}
