package com.openexchange.office.rest.mention;

import java.text.MessageFormat;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.office.tools.doc.DocumentType;

public class FileLinkCreator {
	
	public static final String SHARED_FOLDER_ID = "10";
	
	public static final MessageFormat MSG_PATTERN = new MessageFormat("{0}appsuite/office?app={1}#!!&app=io.ox/office/{1}&folder={2}&id={3}&comment={4}");
	
	public static String getLinkToFile(AJAXRequestData requestData, String folderId, String fileId, DocumentType docType, String commentId) {
		Object [] args = {requestData.constructURL("", false), docType.name().toLowerCase(), folderId, fileId, commentId};
		return MSG_PATTERN.format(args);
	}

	public static String getLinkToSharedFile(AJAXRequestData requestData, String folderId, String fileId, DocumentType docType, String commentId) {
		Object [] args = {requestData.constructURL("", false), docType.name().toLowerCase(), SHARED_FOLDER_ID, fileId.replace(folderId, SHARED_FOLDER_ID), commentId};
		return MSG_PATTERN.format(args);
	}	
	
	private FileLinkCreator() {}
}
