package com.openexchange.office.rest.mention;

import java.util.Collections;
import java.util.List;

import com.openexchange.user.User;

public class CommentNotificationRecipient {
	
	private final User user;
	
	private final List<CommentNotificationRecipientPositionInComment> commentPositions;

	public CommentNotificationRecipient(User user, List<CommentNotificationRecipientPositionInComment> commentPositions) {
		this.user = user;
		this.commentPositions = Collections.unmodifiableList(commentPositions);
	}

	public User getUser() {
		return user;
	}

	public List<CommentNotificationRecipientPositionInComment> getCommentPositions() {
		return commentPositions;
	}
	
	public boolean isGuest() {
		return user.isGuest();
	}
		
	public String getEmailAddress() {
		return user.getMail();
	}
}
