/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.monitoring;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.TimeZone;

import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Service;

import com.openexchange.office.monitoring.api.IMonitoringMemory;
import com.openexchange.office.tools.common.memory.MemoryObserver;
import com.udojava.jmx.wrapper.JMXBean;
import com.udojava.jmx.wrapper.JMXBeanAttribute;

@JMXBean
@ManagedResource(objectName="com.openexchange.office:name=OfficeMemoryMonitoring")
@Service
public class OfficeMemoryMonitoring implements IMonitoringMemory {
    public static final String DOMAIN = "com.openexchange.office";

    @JMXBeanAttribute(name="Observed_MemPool_Name")
	@Override
	public String getObserved_MemPool_Name() {
        return MemoryObserver.get().getObservedMemPoolName();
	}

    @JMXBeanAttribute(name="Observed_MemPool_MaxSize")
	@Override
	public long getObserved_MemPool_MaxSize() {
		return MemoryObserver.get().getObservedMemPoolMaxSize();
	}

    @JMXBeanAttribute(name="Observed_MemPool_ExceedThreshold")
	@Override
	public long getObserved_MemPool_ExceedThreshold() {
		return MemoryObserver.get().getMemPoolThreshold();
	}

    @JMXBeanAttribute(name="Observed_MemPool_PeakUsage")
	@Override
	public long getObserved_MemPool_PeakUsage() {
		return MemoryObserver.get().getObservedMemPoolPeakUsage();
	}

    @JMXBeanAttribute(name="Observed_MemPool_ExceedThresholdNotification_Count")
	@Override
	public long getObserved_MemPool_ExceedThresholdNotification_Count() {
		return MemoryObserver.get().getObservedMemPoolThresholdCount();
	}

    @JMXBeanAttribute(name="Heap_EstimatedFreeSize")
	@Override
	public long getHeap_EstimatedFreeSize() {
		return MemoryObserver.get().getCalcFreeHeapSize();
	}
    
    @JMXBeanAttribute(name="Heap_MaxSize")
	@Override
	public long getHeap_MaxSize() {
		return Runtime.getRuntime().maxMemory();
	}
    
    @JMXBeanAttribute(name="Heap_ExceedThreshold")
	@Override
	public long getHeap_ExceedThreshold() {
		return MemoryObserver.get().getMaxHeapExceedThreshold();
	}

    @JMXBeanAttribute(name="Heap_ExceedThresholdNotification_Count")
	@Override
    public long getHeap_ExceedThresholdNotification_Count() {
    	return MemoryObserver.get().getCountHeapThresholdNotifications();
    }

    @JMXBeanAttribute(name="Documents_NotLoadedDueTo_MemoryPressure_Count")
	@Override
    public long getDocuments_NotLoadedDueTo_MemoryPressure_Count() {
    	return MemoryObserver.get().getNumOfDocsNotLoadedDueToMemPressure();
    }

    @JMXBeanAttribute(name="GC_Triggered_Count")
	@Override
	public long getGC_Triggered_Count() {
		return MemoryObserver.get().getNumOfGCTriggered();
	}

    @JMXBeanAttribute(name="GC_Last_Triggered")
	@Override
	public String getGC_Last_Triggered() {
		final LocalDateTime gcLastRun = MemoryObserver.get().getGCLastTriggered();
		final ZonedDateTime zoneDateTime = gcLastRun.atZone(TimeZone.getTimeZone("UTC").toZoneId());
		return zoneDateTime.toString();
	}
}
