/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.monitoring.api;



/**
 * {@link IInformation}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public interface IMonitoringCommon {

    public String getAdvisoryLockInfo_Mode();

    public long getDocumentsCreated_Total();

    public long getDocumentsCreated_Text();

    public long getDocumentsCreated_Spreadsheet();

    public long getDocumentsCreated_Presentation();

    public long getDocumentsSizeMedian_Total();

    public long getDocumentsSizeMedian_Text();

    public long getDocumentsSizeMedian_Spreadsheet();

    public long getDocumentsSizeMedian_Presentation();

    public long getRestoreDocsCreated_Total();

    public long getRestoreDocsRemoved_Total();

    public long getRestoreDocs_Current();

    public long getRestoreDocsRestored_Success();

    public long getRestoreDocsRestored_Failure();

    public long getRestoreDocsManagedFiles_Current();

    public long getRestoreDocsManagedFiles_RemovedLastCycle();

    public long getRestoreDocsManagedFiles_InRemoveQueue();

    public long getRestoreDocsManagedFiles_RuntimeLastCycle();

    public long getRestoreDocsOpsMsgs_StoredLastCycle();

    public long getRestoreDocsOpsMsgs_StoreTimeNeededLastCycle();

    public long getBackgroundSave_SavedLastCycle();

    public long getBackgroundSave_TimeNeededLastCycle();

    public long getBackgroundSave_AverageTimePerDoc();

    public long getBackgroundSave_Setting_MaxTimeForSave();

    public long getBackgroundSave_Setting_MinTimeForFasterSave();

    public long getBackgroundSave_Setting_MinNumOfMessagesForSave_Text();

    public long getBackgroundSave_Setting_MinNumOfMessagesForSave_Spreadsheet();

    public long getBackgroundSave_Setting_MinNumOfMessagesForSave_Presentation();
}
