/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.htmldoc;

import java.util.Map.Entry;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import com.openexchange.office.filter.api.OCKey;

public class SimpleField
        extends SubNode
{
    private static final String BEFORECLASS = "<div contenteditable=\"false\" class=\"inline field";
    private static final String BEFORETYPE  = "\"";
    private static final String AFTERTYPE   = "><span ";
    private static final String AFTERATTRS  = " >";
    private static final String CLOSEFIELD  = "</span></div>";

    private final String        fieldText;
    private final String              type;

    // ///////////////////////////////////////////////////////////

    public SimpleField(
            int position, String representation, String type)
    {
        super(position, 1);

        this.fieldText = representation;
        this.type = type;
    }

	@Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {
        document.append(BEFORECLASS);

        JSONObject attrs = getAttribute();
        if (attrs == null)
        {
            attrs = new JSONObject();
        }

        JSONObject field = attrs.optJSONObject(OCKey.FIELD.value());
        JSONObject jq = GenDocHelper.getJQueryData(attrs);
        if (type != null)
        {
            jq.put(OCKey.TYPE.value(), type);
        }
		if (null != field) {
			for (Entry<String, Object> e : field.entrySet()) {
				jq.put(e.getKey(), e.getValue());
			}
		}

        if (type != null)
        {
            String type = this.type;
            // System.out.println("Field.appendContent() before: '" + type + "'");

            type = type.trim().split(" ")[0];
            // System.out.println("Field.appendContent() after : '" + type + "'");

            document.append(" field-");

            document.append(GenDocHelper.escapeUIString(type));
        }

        if (StringUtils.isEmpty(fieldText))
        {
            if (type != null)
            {
                document.append(" ");
            }
            document.append("empty-field");
        }

        document.append(BEFORETYPE);



        GenDocHelper.appendJQueryData(document, jq);

        document.append(AFTERTYPE);

        JSONObject jq2 = GenDocHelper.getJQueryData(getAttribute());
        GenDocHelper.appendJQueryData(document, jq2);

        document.append(AFTERATTRS);

        document.append(GenDocHelper.escapeUIString(fieldText));

        document.append(CLOSEFIELD);

        return true;
    }

    @Override
    public boolean needsEmptySpan()
    {
        return true;
    }

    @Override
    public String toString()
    {
        return "Field: " + fieldText;
    }

}
