/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.htmldoc;

import org.json.JSONObject;

public class RangeMarker
        extends SubNode
{

    private static final String RANGEMARKERSTART = "<div contenteditable=\"false\" class=\"inline rangemarker ";
    private static final String RANGEMARKERSTARTCLASS = "rangestart";
    private static final String RANGEMARKERENDCLASS = "rangeend";
    private static final String RANGEMARKERCLOSER = "\" ";
    private static final String RANGEMARKERTYPE = "data-range-type=\"";
    private static final String RANGEMARKERID = "data-range-id=\"";
    private static final String RANGEMARKEREND = "></div>";

    private String              id;
    private String              type;
    private String              position;
    private JSONObject          attrs		 = null;

    // ///////////////////////////////////////////////////////////

    public RangeMarker(
            int logicalPosition, String id, String type, String position)
    {
        super(logicalPosition, 1);

        this.id = id;
        this.type = type;
        this.position = position;
    }

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {
        document.append(RANGEMARKERSTART);

        if (this.position.equalsIgnoreCase("start"))
        {
            document.append(RANGEMARKERSTARTCLASS);
        }
        else if (this.position.equalsIgnoreCase("end"))
        {
            document.append(RANGEMARKERENDCLASS);
        }

        document.append(RANGEMARKERCLOSER);
        document.append(RANGEMARKERTYPE + GenDocHelper.escapeUIString(this.type) + RANGEMARKERCLOSER);
        document.append(RANGEMARKERID + GenDocHelper.escapeUIString(this.id) + RANGEMARKERCLOSER);


        JSONObject params = new JSONObject();
        if(id!=null) {
        	params.put("rangeId", id);
        }
        params.put("rangeType", type);

        attrs = getAttribute();
        if(attrs!=null) {
        	params.put("attributes", attrs);
        }

        GenDocHelper.appendJQueryData(document, params);

        document.append(RANGEMARKEREND);

        return true;
    }

    @Override
    public boolean needsEmptySpan()
    {
        return true;
    }

    @Override
    public String toString()
    {
        return "RangeMarker";
    }

}
