/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.htmldoc;

public class HardBreak
        extends SubNode
{

    private String textContent           = "<br/>";
    private String type                  = "textWrapping";
    private String before                = "";
    private String after                 = "";
    private String hardBreakSpanTypePage = "";

    // ///////////////////////////////////////////////////////////

    public HardBreak(
            int position, String type)
    {
        super(position, 1);
        if ((type != null) && (!type.isEmpty()))
        {
            this.type = type;
        }
        if (this.type.equalsIgnoreCase("page") || this.type.equalsIgnoreCase("column"))
        {
            this.textContent = " ";
            this.hardBreakSpanTypePage = "class='ms-hardbreak-page'";
        }
        this.before = "<div contenteditable='false' class='inline hardbreak' jquerydata=\"{&quot;type&quot;:&quot;" + this.type + "&quot;}\"><span ";
        this.after = " " + this.hardBreakSpanTypePage + ">" + this.textContent + "</span></div>";
    }

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {
        document.append(this.before);
        GenDocHelper.appendAttributes(getAttribute(), document);
        document.append(this.after);
        return true;
    }

    @Override
    public boolean needsEmptySpan()
    {
        return true;
    }

    @Override
    public boolean hasManualPageBreak()
    {
        if (this.type.equalsIgnoreCase("page"))
        {
            return true;
        }
        return super.hasManualPageBreak();
    }

    public String getType()
    {
        return type;
    }
}
