/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.htmldoc;

import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.openexchange.config.ConfigurationService;
import com.openexchange.office.tools.annotation.RegisteredService;
import com.openexchange.office.tools.doc.ApplicationType;
import com.openexchange.office.tools.service.config.UserConfigurationFactory;
import com.openexchange.office.tools.service.config.UserConfigurationHelper;
import com.openexchange.office.tools.service.config.UserConfigurationHelper.Mode;
import com.openexchange.session.Session;

@Service
@RegisteredService
public class GenericHtmlDocumentBuilder
{
    private final static Logger LOG = LoggerFactory.getLogger(GenericHtmlDocumentBuilder.class);
    
    @Autowired
    private UserConfigurationFactory userConfigFactory;

    @Autowired
    private ConfigurationService configService;
    
    public String buildHtmlDocument(String module, JSONObject documentOperations, DocMetaData docMetaData, Session session) {
        if (StringUtils.endsWith(docMetaData.getFileName(), "_ox")) {
            // TODO: is this check good enough
            LOG.debug("RT connection: Fastload is not running for broken files!!!. docDetails: {}, id: {}, source: {} ", docMetaData.getFileName(), docMetaData.getId(), docMetaData.getSource());
            return null;
        }

        if ( !documentOperations.hasAndNotNull("operations")) {
            LOG.info("RT connection: Fastload for module {} could not run with missing operations. docDetails: {}, id: {}, source: {}", docMetaData.getFileName(), docMetaData.getId(), docMetaData.getSource());
            return null;
        }

        final TextTableLimits tableLimits = ConfHelper.getTextTableLimits(getUserHelper(session));

        if (module.equalsIgnoreCase("text")) {
            return TextHtmlDocumentBuilder.buildHtmlDocument(documentOperations, docMetaData, tableLimits);
        }
        return PresentationHtmlDocumentBuilder.buildHtmlDocument(documentOperations, docMetaData, tableLimits);
    }

    private UserConfigurationHelper getUserHelper(Session session) {
        return userConfigFactory.create(session, "io.ox/office", Mode.WRITE_BACK);
    }

    public boolean isFastLoadActive(String module, Session session) {
        if (configService.getBoolProperty("io.ox/office//module/debugavailable", false)) {
            return userConfigFactory.create(session, "io.ox/office", Mode.WRITE_BACK).getBoolean(module + "/useFastLoad", true);
        }
        return true;
    }

    public static boolean isFastLoadSupported(String module)
    {
        if (ApplicationType.APP_PRESENTATION_STRING.equalsIgnoreCase(module))
            return true;
        else if (ApplicationType.APP_TEXT_STRING.equalsIgnoreCase(module))
            return true;
        return false;
    }

}
