/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.htmldoc;

import org.json.JSONArray;
import org.json.JSONObject;
import com.openexchange.office.filter.api.OCKey;

public class Container
        extends NodeHolder
{

    private final String id;
    private final String target;
    private final int index;

    public Container(
            int index, String id, String target, boolean invisible, boolean notSelectable, JSONObject attrs)
                throws Exception
    {
        this.index = index;
        this.id = id;
        this.target = target;

        if (!"pagecontent".equals(id))
        {
            this.insert(new JSONArray().put(0), new SlideParagraph(id, target));
        }

        if (null != attrs) {
            JSONArray newStart = new JSONArray().put(0);
            setAttribute(newStart, newStart, attrs);
        }
    }

    public int getIndex()
    {
        return index;
    }

    @Override
    public boolean setAttribute(
        JSONArray start,
        JSONArray end,
        JSONObject attrs)
            throws Exception
    {
        //return getChildren().get(0).setAttribute(start, end, attrs);
        return super.setAttribute(start, end, attrs);
    }



    @Override
    public boolean needsEmptySpan()
    {
        return false;
    }

    @Override
    public boolean appendContent(
        StringBuilder document)
            throws Exception
    {

        if ("pagecontent".equals(id))
        {
            document.append("<div class='pagecontent'");
        }
        else
        {
            document.append("<div class='slidecontainer' data-container-id='" + GenDocHelper.escapeUIString(id) + "'");

            final JSONObject adapter = GenDocHelper.getJQueryData(getAttribute(), false);
            adapter.put(OCKey.ID.value(), id);

            if (target != null)
            {
                adapter.put(OCKey.TARGET.value(), target);
            }
            GenDocHelper.appendJQueryData(document, adapter);
        }

        document.append(">");

        super.appendContent(document);

        document.append("</div>");

        return true;
    }

}
