package com.openexchange.office.hazelcast.core.doc;

import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;

@Service
public class HazelcastMapnameDisposer {

	@Autowired
	protected HazelcastInstance hzInstance;
	
	private Map<String, String> mapPrefixToMapName = new HashMap<>();
	
    //-------------------------------------------------------------------------
	/**
	 * Discovers map names in the supplied hazelcast configuration based on the map prefix.
	 *
	 * @param config The config object
	 * @return The prefix of the map name
	 */
	public String discoverMapName(String mapPrefix){
		if (mapPrefixToMapName.containsKey(mapPrefix)) {
			return mapPrefixToMapName.get(mapPrefix);
		}
	    Map<String, MapConfig> mapConfigs = hzInstance.getConfig().getMapConfigs();
	    if (null != mapConfigs && 0 < mapConfigs.size()) {
	        for (String mapName : mapConfigs.keySet()) {
	            if (mapName.startsWith(mapPrefix)) {
	            	mapPrefixToMapName.put(mapPrefix, mapName);
	                return mapName;
	            }
	        }
	    }
	    return null;
	}	

}
