package com.openexchange.office.hazelcast.core.doc;

import org.springframework.stereotype.Service;

import com.hazelcast.core.IMap;
import com.openexchange.exception.OXException;
import com.openexchange.office.hazelcast.serialization.document.PortableCleanupStatus;

@Service
public class HazelcastDocumentCleanupLock extends HazelcastDocService {

    @Override
	public void afterPropertiesSet() throws Exception {
    	this.mapIdentifier = hzMapnameDisposer.discoverMapName("officeCleanupLock-");
	}

    /**
     * Get the mapping of full IDs to the Resource e.g. ox://marc.arens@premium/random <-> Resource. The resource includes the
     * {@link RoutingInfo} needed to address clients identified by the {@link ID}
     *
     * @return the map used for mapping full IDs to ResourceMaps.
     * @throws OXException if the map couldn't be fetched from hazelcast
     */
    public IMap<String, PortableCleanupStatus> getCleanupLockMapping() throws OXException {
        return hzInstance.getMap(mapIdentifier);
    }
}
