/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.api;

import java.util.HashMap;

import org.w3c.dom.DocumentType;

/**
 * {@link DocumentType}
 *
 * @author <a href="mailto:sven.jacobi@open-xchange.com">Sven Jacobi</a>
 */
public class DocumentProperties extends HashMap<String, Object> {

	private static final long serialVersionUID = 4912557177778757666L;

	// TYPE String
    static final public String PROP_CREATOR = "Creator";

    // TYPE String
    static final public String PROP_LAST_MODIFIED_BY = "LastModifiedBy";

    // TYPE String
    static final public String PROP_USER_LANGUAGE = "UserLanguage";

    // TYPE String
    static final public String PROP_REVISION = "Revision";

    // TYPE String
    static final public String PROP_VERSION = "Version";

    // TYPE String
    static final public String PROP_INITIAL_SHEETNAME = "InitialSheetName";

    // TYPE String (stringified JSON object)
    static final public String PROP_INITIAL_FORMATS = "InitialFormats";

    // TYPE String
    static final public String PROP_UNIQUE_DOCUMENT_IDENTIFIER = "UniqueDocumentIdentifier";

    // TYPE Boolean
    static final public String PROP_SAVE_TEMPLATE_DOCUMENT = "SaveTemplateDocument";

    static final public String PROP_PREVIEWDATA = "PreviewData";

    static final public String PROP_DOCUMENT = "Document";

    // TYPE Integer
    static final public String PROP_SPREADHSEET_ACTIVE_SHEET_INDEX = "ActiveSheetIndex";

    // TYPE Integer
    static final public String PROP_SPREADHSEET_CURRENT_SHEET_INDEX = "CurrentSheetIndex";

    // TYPE Integer
    static final public String PROP_SPREADSHEET_SHEET_COUNT = "SheetCount";

    // TYPE Boolean
    static final public String PROP_CALCULATE_ON_LOAD = "CalculateOnLoad";

    // TYPE Long
    static final public String PROP_PAGESIZE_WIDTH = "PageSizeWidth";

    static final public String PROP_PAGESIZE_HEIGHT = "PageSizeHeight";

    // TYPE Boolean
    static final public String PROP_CREATED_BY_DEFAULT_TEMPLATE = "DefaultTemplate";

    // TYPE Boolean
    static final public String PROP_SAVE_DOC_HISTORY = "SaveDocumentHistory";

    public String optString(String key, String _default) {
        final Object val = get(key);
        if (val instanceof String) {
            return (String) val;
        }
        return _default;
    }

    public boolean optBoolean(String key, boolean _default) {
        final Object val = get(key);
        if (val instanceof Boolean) {
            return ((Boolean) val).booleanValue();
        }
        return _default;
    }

    public Integer optInteger(String key, int _default) {
        final Object val = get(key);
        if (val instanceof Integer) {
            return (Integer) val;
        }
        return _default;
    }

    public long optLong(String key, long _default) {
        final Object val = get(key);
        if (val instanceof Long) {
            return ((Long) val).longValue();
        }
        return _default;
    }

}
