package com.openexchange.office.fields;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.office.tools.doc.DocumentFormat;

public class FieldsParserJSONSheets implements FieldsParser {

	private IDBasedFileAccess fileAccess;
    private final String         fileId;
    private final DocumentFormat format;

    public FieldsParserJSONSheets(IDBasedFileAccess fileAccess, String fileId, DocumentFormat format)
    {
    	this.fileAccess = fileAccess;
        this.fileId = fileId;
        this.format = format;
    }

    @Override
    public Map<String, Object> getFields()
        throws Exception
    {
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileAccess.getDocument(fileId, FileStorageFileAccess.CURRENT_VERSION), "UTF-8"));

        List<String> allLines = new ArrayList<String>();
        StringBuilder all = new StringBuilder();
        String line = reader.readLine();
        while (null != line)
        {
            allLines.add(line);
            all.append(line);
            line = reader.readLine();
        }
        String param = all.toString();

        try
        {
            new JSONObject(param);

            if (format == DocumentFormat.XLSX || format == DocumentFormat.ODS)
            {
                return new FieldsParserSheets(param).getFields();
            }
            else
            {
                return new FieldsParserParam(param).getFields();
            }
        }
        catch (JSONException e)
        {
            return new FieldsParserCSV(allLines).getFields();           
        }
    }

}
