/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package org.xlsx4j.sml_2018;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.xlsx4j.sml.CTExtensionList;

/**
 *
 * This complex type specifies a collection of persons.
 *
 * <xsd:complexType name="CT_PersonList">
 *  <xsd:sequence>
 *   <xsd:element name="person" type="CT_Person" minOccurs="0" maxOccurs="unbounded"/>
 *   <xsd:element name="extLst" type="x:CT_ExtensionList" minOccurs="0" maxOccurs="1"/>
 *  </xsd:sequence>
 * </xsd:complexType>
 */

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CTPersonList", propOrder = {})
@XmlRootElement(name="personList")
public class CTPersonList {

    @XmlElement
    protected CTExtensionList extLst;

    @XmlElement(name = "person")
    protected List<CTPerson> persons;

    public void setPersons(List<CTPerson> persons) {
        this.persons = persons;
    }

    public List<CTPerson> getPersons() {
        if (persons == null) {
            persons = new ArrayList<>();
        }
        return persons;
    }

    public CTExtensionList getExtLst() {
        return extLst;
    }

    public void setExtLst(CTExtensionList extLst) {
        this.extLst = extLst;
    }

    public CTPerson getPersonById(String id) {

        if (persons != null && id != null && !id.isEmpty()) {
            for (CTPerson p : persons) {
                if (id.equals(p.getId())) {
                    return p;
                }
            }
        }

        return null;
    }

    public CTPerson getPerson(String displayName, String userId, String providerId) {
        CTPerson person = null;
        if (persons != null && displayName != null && !displayName.isEmpty() && userId != null) {
            for (CTPerson p : persons) {
                if (displayName.equals(p.getDisplayName()) && userId.equals(p.getUserId()) && ((providerId == null && p.getProviderId() == null) || (providerId != null && providerId.equals(p.getProviderId())))) {
                    person = p;
                }
            }
        }
        return person;
    }
}
