/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.document.api;

import org.json.JSONObject;

import com.openexchange.file.storage.File;
import com.openexchange.office.tools.common.error.ErrorCode;

/**
 * Property class to transport result data for a rename request.
 *
 * @author Carsten Driesner
 *
 */
public class RenameResult {

    private ErrorCode errorCode;
    private File metaData;
    private JSONObject jsonResult;
    private String newFileId;
    private boolean reload;

    /**
     * Creates a success rename result object.
     */
    public RenameResult() {
        this.errorCode = ErrorCode.NO_ERROR;
        this.metaData = null;
        this.jsonResult = new JSONObject();
        this.newFileId = null;
        this.reload = false;
    }

    /**
     * Creates a rename result object with the provided
     * error code and meta data.
     *
     * @param errorCode the error code from the rename processing.
     * @param metaData the new mata data or null if not available.
     */
    public RenameResult(final ErrorCode errorCode, final File metaData, final String newFileId) {
        this.errorCode = errorCode;
        this.metaData = metaData;
        this.jsonResult = new JSONObject();
        this.newFileId = newFileId;
    }

    public ErrorCode errorCode() {
    	return errorCode;
    }

    public File metaData() {
    	return metaData;
    }

    public JSONObject jsonResult() {
    	return jsonResult;
    }

    public String newFileId() {
    	return newFileId;
    }

    public boolean reload() {
    	return reload;
    }

    public void setErrorCode(ErrorCode errorCode) {
    	this.errorCode = errorCode;
    }

    public void setMetaData(File metaData) {
    	this.metaData = metaData;
    }

    public void setJsonResult(JSONObject jsonResult) {
    	this.jsonResult = jsonResult;
    }

    public void setNewFileId(String newFileId) {
    	this.newFileId = newFileId;
    }

    public void setReload(boolean reload) {
    	this.reload = reload;
    }
}
