/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.document.api;

import java.io.InputStream;

import com.openexchange.office.document.OXDocumentFactoryImpl;
import com.openexchange.office.imagemgr.IResourceManager;
import com.openexchange.office.tools.annotation.ConcreteService;
import com.openexchange.office.tools.common.debug.SaveDebugProperties;
import com.openexchange.office.tools.common.user.UserData;
import com.openexchange.office.tools.service.storage.StorageHelperService;
import com.openexchange.session.Session;

@ConcreteService(clazz=OXDocumentFactoryImpl.class)
public interface OXDocumentFactory {

    //-------------------------------------------------------------------------
    /**
     * Creates a new OXDocumentInfo instance.
     *
     * @param session
     *            The session of the client that requested a service which needs documents access.
     * @param fileId
     *            The file id of the file to be accessed.
     */
	public OXDocumentInfo createDocumentInfoAccess(Session session, String fileId, boolean newDoc);

    //-------------------------------------------------------------------------
    /**
     * Creates a new OXDocumentInfo instance.
     *
     * @param session
     *            The session of the client that requested a service which needs documents access.
     * @param services
     *            The service lookup instance to be used by this instance.
     * @param userData
     *            The UserData instance of the user associated with the session.
     * @param newDoc
     *            Specifies, if this instance references a new document or not.
     */
    public OXDocumentInfo createDocumentInfoAccess(Session session, UserData userData, boolean newDoc);

    //-------------------------------------------------------------------------
    /**
     * Create a new OXDocument instance.
     *
     * @param session
     *            The session of the client that requested a service which needs documents access.
     * @param services
     *            The service lookup instance to be used by this instance.
     * @param folderId
     *            The folder id of the file to be accessed.
     * @param fileId
     *            The file id of the file to be accessed.
     * @param fileHelper
     *            The FileHelper instance that is responsible for the file access regarding the document.
     * @param newDoc
     *            Specifies, if this instance references a new document or not.
     * @param resourceManager
     *            The ResourceManager instance which stores resources addressed by the document to be available via REST-API and
     *            other documents.
     */
    public OXDocument createDocumentAccess(Session session, String folderId, String fileId, boolean newDoc, final IResourceManager resourceManager, boolean logDocContext, final SaveDebugProperties dbgProps);

    //-------------------------------------------------------------------------
    /**
     * Create a new OXDocument instance.
     *
     * @param session
     *            The session of the client that requested a service which needs documents access.
     * @param userData
     *            The UserData instance of the user associated with the session.
     * @param fileHelper
     *            The FileHelper instance that is responsible for the file access regarding the document.
     * @param newDoc
     *            Specifies, if this instance references a new document or not.
     * @param resourceManager
     *            The ResourceManager instance which stores resources addressed by the document to be available via REST-API and
     *            other documents.
     * @param storageHelper
     *            A helper instance which provides data to the referenced document storage. The instance must be
     *            initialized with the same folderId, where the document itself is stored.
     */
	public OXDocument createDocumentAccess(Session session, UserData userData, boolean newDoc, IResourceManager resourceManager, boolean logDocContext,	SaveDebugProperties dbgProps);

    //-------------------------------------------------------------------------
    /**
     * Create a new OXDocument instance.
     *
     * @param session
     * @param services
     * @param docStream
     * @param fileName
     * @param mimeType
     * @param resourceManager
     * @param storageHelper
     */
    public OXDocument createDocumentAccess(Session session, InputStream docStream, String fileName, String mimeType, IResourceManager resourceManager, StorageHelperService storageHelper);
}
