package com.openexchange.office.dcs.registry;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.openexchange.config.ConfigurationService;
import com.openexchange.database.JdbcProperties;
import com.openexchange.office.tools.annotation.RegisteredService;
import com.openexchange.office.tools.database.ConnectionData;
import com.openexchange.office.tools.database.DatabaseConfiguration;

@Service
@RegisteredService(registeredClass=ConnectionData.class)
public class DcsDatabaseConfiguration extends DatabaseConfiguration {

    public static final String DB_CLIENT_URL_KEY = "com.openexchange.dcs.client.database";
    
    public static final String DB_CLIENT_JDBC_CONFIG_PREFIX = "com.openexchange.dcs.client.database.jdbc";
	
    private static final int DEFAULT_CONNECTION_POOLSIZE = 5;

    @Autowired
    private ConfigurationService configurationService;

    @Autowired
    private JdbcProperties jdbcProperties;

    public DcsDatabaseConfiguration() {
        super(DB_CLIENT_URL_KEY, DB_CLIENT_JDBC_CONFIG_PREFIX);
    }

    /**
     * Overrides the max. connection pool size method with a default
     * of DEFAULT_CONNECTION_POOLSIZE (5) since we don't need a
     * super class default pool size (30) that large for this database
     *
     * @return The number of open connections within the database connection pool.
     *  Default is 5.
     */
    @Override
    public int getConnectionPoolSize() {
        return this.getConfigurationService().getIntProperty(this.getConfigPrefix() + "connectionPool.maxPoolSize",
            DcsDatabaseConfiguration.DEFAULT_CONNECTION_POOLSIZE);
    }

	@Override
	protected ConfigurationService getConfigurationService() {
		return configurationService;
	}

	@Override
	protected JdbcProperties getJdbcPropertiesService() {
		return jdbcProperties;
	}
}
