/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.datasource.access;

public class MetaData {
    private final String folderId; // used for toString building
    private final String id; // used for toString building
    private final String versionOrAttachment;  // used for toString building
	private final long fileSize; // used for toString building
	private final String fileName; // used for toString building
	private final String hash; // used for toString building
	private final String source; // used for toString building
	private String mimeType;  // NOT used for toString building

	public MetaData(String folderId, String id, String versionOrAttachment, long fileSize, String fileName, String hash, String source) {
	    this.folderId = folderId;
	    this.id = id;
	    this.versionOrAttachment = versionOrAttachment;
		this.fileName = fileName;
		this.fileSize = fileSize;
		this.hash = hash;
		this.source = source;
		this.mimeType = "";
	}

	/**
	 * The toString method uses every member except <code>mimeType</code>,
	 * which is not an essential part of the class and might be used otherwise
	 */
	@Override
    public String toString() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("MetaData [folderId=");
        builder.append(folderId);
        builder.append(", id=");
        builder.append(id);
        builder.append(", versionOrAttachment=");
        builder.append(versionOrAttachment);
        builder.append(", fileSize=");
        builder.append(fileSize);
        builder.append(", fileName=");
        builder.append(fileName);
        builder.append(", hash=");
        builder.append(hash);
        builder.append(", source=");
        builder.append(source);
        builder.append("]");
        return builder.toString();
    }

    public MetaData(String folderId, String id, String versionOrAttachment, long fileSize, String fileName, String hash, String source, String mimeType) {
	    this(folderId, id, versionOrAttachment, fileSize, fileName, hash, source);
		this.mimeType = mimeType;
	}

    public String getFolderId() {
        return folderId;
    }

    public String getId() {
        return id;
    }

    public String getVersionOrAttachment() {
        return versionOrAttachment;
    }

	public long getFileSize() {
		return fileSize;
	}

	public String getFileName() {
		return fileName;
	}

	public String getMimeType() {
		return mimeType;
	}

	public String getHash() {
		return hash;
	}

	public String getSource() {
	    return source;
	}

	public void setMimeType(String mimeType) {
		this.mimeType = mimeType;
	}

}
