/*
*
*    OPEN-XCHANGE legal information
*
*    All intellectual property rights in the Software are protected by
*    international copyright laws.
*
*
*    In some countries OX, OX Open-Xchange, open xchange and OXtender
*    as well as the corresponding Logos OX Open-Xchange and OX are registered
*    trademarks.
*    The use of the Logos is not covered by the GNU General Public License.
*    Instead, you are allowed to use these Logos according to the terms and
*    conditions of the Creative Commons License, Version 2.5, Attribution,
*    Non-commercial, ShareAlike, and the interpretation of the term
*    Non-commercial applicable to the aforementioned license is published
*    on the web site http://www.open-xchange.com/EN/legal/index.html.
*
*    Please make sure that third-party modules and libraries are used
*    according to their respective licenses.
*
*    Any modifications to this package must retain all copyright notices
*    of the original copyright holder(s) for the original code used.
*
*    After any such modifications, the original and derivative code shall remain
*    under the copyright of the copyright holder(s) and/or original author(s)per
*    the Attribution and Assignment Agreement that can be located at
*    http://www.open-xchange.com/EN/developer/. The contributing author shall be
*    given Attribution for the derivative code and a license granting use.
*
*     Copyright (C) 2016 OX Software GmbH
*     Mail: info@open-xchange.com
*
*
*     This program is free software; you can redistribute it and/or modify it
*     under the terms of the GNU General Public License, Version 2 as published
*     by the Free Software Foundation.
*
*     This program is distributed in the hope that it will be useful, but
*     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
*     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
*     for more details.
*
*     You should have received a copy of the GNU General Public License along
*     with this program; if not, write to the Free Software Foundation, Inc., 59
*     Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*/
package com.openexchange.office.backup.manager;

import java.io.InputStream;

import org.json.JSONArray;

import com.openexchange.office.imagemgr.IResourceManager;
import com.openexchange.office.tools.common.error.ErrorCode;

public class DocumentRestoreData {

    private IResourceManager resourceManager;
    private InputStream inputStream;
    private JSONArray operations;
    private ErrorCode errorCode = ErrorCode.NO_ERROR;
    private int baseOSN;
    private String baseVersion;
    private int osn;
    private String fileName;
    private String mimeType;

    public DocumentRestoreData() { }

    public DocumentRestoreData(final IResourceManager resourceManager, final InputStream inputStream, final JSONArray operations, final ErrorCode errorCode, int baseOSN, final String baseVersion) {
        this.resourceManager = resourceManager;
        this.inputStream = inputStream;
        this.operations = operations;
        this.errorCode = errorCode;
        this.baseOSN = baseOSN;
        this.baseVersion = baseVersion;
        this.osn = baseOSN;
    }

    public final IResourceManager getResourceManager() { return this.resourceManager; }
    public final InputStream getInputStream() { return this.inputStream; }
    public final JSONArray getOperations() { return this.operations; }
    public final ErrorCode getErrorCode() { return this.errorCode; }
    public final int getBaseOSN() { return this.baseOSN; }
    public final String getBaseVersion() { return this.baseVersion; }
    public final int getOSN() { return this.osn; }
    public final String getFileName() { return this.fileName; }
    public final String getMimeType() { return this.mimeType; }

    public void setInputStream(final InputStream inputStream) { this.inputStream = inputStream; }
    public void setOperations(final JSONArray operations) { this.operations = operations; }
    public void setErrorCode(final ErrorCode errorCode) { this.errorCode = errorCode; }
    public void setResourceManager(final IResourceManager resourceManager) { this.resourceManager = resourceManager; }
    public void setBaseOSN(final int baseOSN) { this.baseOSN = baseOSN; }
    public void setBaseVersion(final String baseVersion) { this.baseVersion = baseVersion; }
    public void setOSN(int osn) { this.osn = osn; }
    public void setFileName(final String fileName) { this.fileName = fileName; }
    public void setMimeType(final String mimeType) { this.mimeType = mimeType; }
}
