/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.config;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.lang.Nullable;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.ClassUtils;

public class JtaTransactionManagerFactoryBean
implements FactoryBean<JtaTransactionManager> {
    private static final String WEBLOGIC_JTA_TRANSACTION_MANAGER_CLASS_NAME = "org.springframework.transaction.jta.WebLogicJtaTransactionManager";
    private static final String WEBSPHERE_TRANSACTION_MANAGER_CLASS_NAME = "org.springframework.transaction.jta.WebSphereUowTransactionManager";
    private static final String JTA_TRANSACTION_MANAGER_CLASS_NAME = "org.springframework.transaction.jta.JtaTransactionManager";
    private static final boolean weblogicPresent;
    private static final boolean webspherePresent;
    @Nullable
    private final JtaTransactionManager transactionManager;

    public JtaTransactionManagerFactoryBean() {
        String className = JtaTransactionManagerFactoryBean.resolveJtaTransactionManagerClassName();
        try {
            Class<?> clazz = ClassUtils.forName(className, JtaTransactionManagerFactoryBean.class.getClassLoader());
            this.transactionManager = (JtaTransactionManager)BeanUtils.instantiateClass(clazz);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Failed to load JtaTransactionManager class: " + className, ex);
        }
    }

    @Override
    @Nullable
    public JtaTransactionManager getObject() {
        return this.transactionManager;
    }

    @Override
    public Class<?> getObjectType() {
        return this.transactionManager != null ? this.transactionManager.getClass() : JtaTransactionManager.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    static String resolveJtaTransactionManagerClassName() {
        if (weblogicPresent) {
            return WEBLOGIC_JTA_TRANSACTION_MANAGER_CLASS_NAME;
        }
        if (webspherePresent) {
            return WEBSPHERE_TRANSACTION_MANAGER_CLASS_NAME;
        }
        return JTA_TRANSACTION_MANAGER_CLASS_NAME;
    }

    static {
        ClassLoader classLoader = JtaTransactionManagerFactoryBean.class.getClassLoader();
        weblogicPresent = ClassUtils.isPresent("weblogic.transaction.UserTransaction", classLoader);
        webspherePresent = ClassUtils.isPresent("com.ibm.wsspi.uow.UOWManager", classLoader);
    }
}

