/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.logback.extensions.logstash;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.net.DefaultSocketConnector;
import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.CloseUtil;
import ch.qos.logback.core.util.Duration;
import com.openexchange.logback.extensions.logstash.LogstashSocketAppenderMBean;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;

public class LogstashSocketAppender
extends AppenderBase<ILoggingEvent>
implements Runnable,
SocketConnector.ExceptionHandler,
LogstashSocketAppenderMBean {
    private static final AtomicReference<LogstashSocketAppender> REF = new AtomicReference();
    private static final float LOAD_FACTOR = 0.67f;
    private static final int ACCEPT_TIMEOUT_CONNECTION = 10000;
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final Object PRESENT = new Object();
    private int port;
    private String remoteHost;
    private InetAddress address;
    BlockingQueue<ILoggingEvent> queue;
    private int queueSize;
    private int loadThreshold;
    private float loadFactor;
    private String peerId;
    private Future<?> task;
    private Future<?> connectionOverwatch;
    private Future<Socket> connectorTask;
    private volatile Socket socket;
    private int reconnectionDelay;
    Duration eventDelayLimit;
    private int acceptConnectionTimeout;
    private int connectionTimeout;
    private Encoder<ILoggingEvent> encoder;
    private boolean alwaysPersistEvents;
    private Boolean keepAlive;
    private final ConcurrentMap<Thread, Object> guard = new ConcurrentHashMap<Thread, Object>(32, 0.9f, 1);
    private final AtomicInteger statusRepeatCount = new AtomicInteger(0);
    private final AtomicInteger exceptionCount = new AtomicInteger(0);
    private OutputStream fallbackOutputStream;
    private OutputStream socketOutputStream;
    static final int ALLOWED_REPEATS = 5;

    public static LogstashSocketAppender getInstance() {
        return REF.get();
    }

    public void start() {
        REF.set(this);
        if (this.isStarted()) {
            return;
        }
        int errorCount = 0;
        if (this.port <= 0) {
            ++errorCount;
            this.logWarn("No port was configured for appender " + this.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_port");
        }
        if (this.remoteHost == null) {
            ++errorCount;
            this.logWarn("No remote host was configured for appender " + this.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_host");
        }
        if (this.queueSize <= 0) {
            this.logInfo("'queueSize' is not defined in configuration file. Falling back to default value of '2048'");
            this.queueSize = 2048;
        }
        this.setOptionalProperties();
        this.fallbackOutputStream = System.err;
        if (errorCount == 0) {
            try {
                this.address = InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException ex) {
                this.logError("unknown host: " + this.remoteHost, ex);
                ++errorCount;
            }
        }
        if (errorCount == 0) {
            this.queue = this.newBlockingQueue(this.queueSize);
            this.peerId = this.remoteHost + ":" + this.port;
            this.task = this.getContext().getScheduledExecutorService().submit(this);
            super.start();
        }
    }

    private void setOptionalProperties() {
        this.alwaysPersistEvents = Boolean.parseBoolean(this.context.getProperty("com.openexchange.logback.extensions.logstash.alwaysPersistEvents"));
        String value = this.context.getProperty("com.openexchange.logback.extensions.logstash.loadFactor");
        if (value == null || !(value instanceof String)) {
            this.logInfo("'com.openexchange.logback.extensions.logstash.loadFactor' property is not defined in the configuration file. Falling back to default value of '0.67'");
            this.loadFactor = 0.67f;
        } else {
            try {
                this.loadFactor = Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                this.logWarn("The value of 'com.openexchange.logback.extensions.logstash.loadFactor' is not a parsable float. Falling back to default value of '0.67'");
                this.loadFactor = 0.67f;
            }
        }
        this.loadThreshold = (int)(this.loadFactor * (float)this.queueSize);
        this.keepAlive = Boolean.parseBoolean(this.context.getProperty("com.openexchange.logback.extensions.logstash.keepAlive"));
        String property = this.context.getProperty("com.openexchange.logback.extensions.logstash.acceptConnectionTimeout");
        if (property == null || !(property instanceof String)) {
            this.logInfo("'com.openexchange.logback.extensions.logstash.acceptConnectionTimeout' property is not defined in the configuration file. Falling back to default value of '10000'");
            this.acceptConnectionTimeout = 10000;
        } else {
            try {
                this.acceptConnectionTimeout = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                this.logWarn("The value of 'com.openexchange.logback.extensions.logstash.acceptConnectionTimeout' is not a parsable integer. Falling back to default value of '10000'");
                this.acceptConnectionTimeout = 10000;
            }
        }
        property = this.context.getProperty("com.openexchange.logback.extensions.logstash.connectionTimeout");
        if (property == null || !(property instanceof String)) {
            this.logInfo("'com.openexchange.logback.extensions.logstash.connectionTimeout' property is not defined in the configuration file. Falling back to default value of '5000'");
            this.connectionTimeout = 5000;
        } else {
            try {
                this.connectionTimeout = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                this.logWarn("The value of 'com.openexchange.logback.extensions.logstash.connectionTimeout' is not a parsable integer. Falling back to default value of '5000'");
                this.connectionTimeout = 5000;
            }
        }
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        CloseUtil.closeQuietly((Socket)this.socket);
        this.task.cancel(true);
        if (this.connectorTask != null) {
            this.connectorTask.cancel(true);
        }
        this.connectionOverwatch.cancel(true);
        this.closeStreams(this.socketOutputStream, this.fallbackOutputStream);
        REF.set(null);
        super.stop();
    }

    public void connectionFailed(SocketConnector connector, Exception ex) {
        this.handleConnectionException(ex);
    }

    private void handleConnectionException(Exception ex) {
        if (ex instanceof InterruptedException) {
            this.logError("Connection to " + this.peerId + " interrupted.", ex);
        } else if (ex instanceof ConnectException) {
            this.logError("Connection to " + this.peerId + " refused.", ex);
        } else if (ex instanceof IOException) {
            this.logError("Connection to " + this.peerId + " failed.", ex);
        } else if (ex instanceof InterruptedException) {
            this.logError("Connection to " + this.peerId + " interupted.", ex);
        } else if (ex instanceof TimeoutException) {
            this.logError("Connection to " + this.peerId + " timed out after " + 5000 + " milliseconds.", ex);
        } else {
            this.logError("Connection error to " + this.peerId + ".", ex);
        }
        try {
            this.cleanQueueIfNecessary();
        }
        catch (IOException e) {
            this.logError("Failed while cleaning queue.", e);
        }
    }

    @Override
    public final void run() {
        try {
            Thread currentThread = Thread.currentThread();
            while (!currentThread.isInterrupted()) {
                try {
                    SocketConnector connector = this.createConnector(this.address, this.port, 0, this.reconnectionDelay);
                    this.connectorTask = this.activateConnector(connector);
                    if (this.connectorTask == null) continue;
                    this.socket = this.waitForConnectorToReturnASocket();
                    if (this.socket == null) continue;
                    this.dispatchEvents();
                }
                catch (Exception e) {
                    this.handleConnectionException(e);
                }
            }
        }
        catch (Throwable t) {
            this.logError("LogstashSocketAppender is shutting down.", t);
        }
    }

    private void dispatchEvents() {
        ILoggingEvent event = null;
        try {
            this.socket.setSoTimeout(this.acceptConnectionTimeout);
            this.socketOutputStream = new BufferedOutputStream(this.socket.getOutputStream());
            this.logInfo("Dispatching events...");
            while (true) {
                if (this.connectionOverwatch.isDone()) {
                    throw new IOException("Remote peer " + this.peerId + " closed the connection.");
                }
                event = this.queue.take();
                this.writeBytes(this.socketOutputStream, this.encoder.encode((Object)event));
                event = null;
            }
        }
        catch (IOException ex) {
            this.handleConnectionException(ex);
            CloseUtil.closeQuietly((Socket)this.socket);
            this.socket = null;
            this.logInfo("Connection to " + this.peerId + " closed.");
            if (event != null) {
                this.doAppend(event);
            }
        }
        catch (InterruptedException ex) {
            try {
                this.handleConnectionException(ex);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                CloseUtil.closeQuietly((Socket)this.socket);
                this.socket = null;
                this.logInfo("Connection to " + this.peerId + " closed.");
                if (event != null) {
                    this.doAppend(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAppend(ILoggingEvent eventObject) {
        Thread currentThread = Thread.currentThread();
        if (null != this.guard.putIfAbsent(currentThread, PRESENT)) {
            return;
        }
        try {
            if (!this.started) {
                if (this.statusRepeatCount.getAndIncrement() < 5) {
                    this.addStatus((Status)new WarnStatus("Attempted to append to non started appender [" + this.name + "].", (Object)this));
                }
                return;
            }
            if (this.getFilterChainDecision(eventObject) == FilterReply.DENY) {
                return;
            }
            this.append(eventObject);
        }
        catch (Exception e) {
            if (this.exceptionCount.getAndIncrement() < 5) {
                this.addError("Appender [" + this.name + "] failed to append.", e);
            }
        }
        finally {
            this.guard.remove(currentThread);
        }
    }

    protected void append(ILoggingEvent event) {
        if (event == null || !this.isStarted()) {
            return;
        }
        int maxRetry = 2;
        boolean inserted = false;
        int i = maxRetry;
        while (!inserted && i-- > 0) {
            inserted = this.queue.offer(event);
            if (inserted) continue;
            try {
                this.cleanQueueIfNecessary();
            }
            catch (IOException e) {
                this.logError("Failed while cleaning queue.", e);
            }
        }
        if (!inserted) {
            this.logError("Dropping event due to timeout limit of [" + this.eventDelayLimit + "] being exceeded", null);
        }
    }

    protected SocketConnector newConnector(InetAddress address, int port, int initialDelay, int retryDelay) {
        return new DefaultSocketConnector(address, port, (long)initialDelay, (long)retryDelay);
    }

    protected SocketFactory getSocketFactory() {
        return SocketFactory.getDefault();
    }

    BlockingQueue<ILoggingEvent> newBlockingQueue(int queueSize) {
        return (BlockingQueue)((Object)(queueSize <= 0 ? new SynchronousQueue() : new ArrayBlockingQueue(queueSize)));
    }

    private SocketConnector createConnector(InetAddress address, int port, int initialDelay, int retryDelay) {
        this.logInfo("Creating socket connector for " + this.peerId + " ...");
        SocketConnector connector = this.newConnector(address, port, initialDelay, retryDelay);
        connector.setExceptionHandler((SocketConnector.ExceptionHandler)this);
        connector.setSocketFactory(this.getSocketFactory());
        this.logInfo("Socket connector for " + this.peerId + " created.");
        return connector;
    }

    private Future<Socket> activateConnector(SocketConnector connector) {
        this.logInfo("Submitting socket connector to the executor service...");
        Future<Socket> task = this.getContext().getScheduledExecutorService().submit(connector);
        this.logInfo("Connector task returned.");
        return task;
    }

    private Socket waitForConnectorToReturnASocket() throws InterruptedException, ExecutionException, IOException, TimeoutException {
        this.logInfo("Trying to connect to " + this.peerId + "...");
        Socket s = this.connectorTask.get(this.connectionTimeout, TimeUnit.MILLISECONDS);
        s.setKeepAlive(this.keepAlive);
        this.logInfo("Connection established to " + this.peerId + ".");
        this.connectorTask = null;
        this.connectionOverwatch = this.getContext().getScheduledExecutorService().submit(new ConnectionOverwatch(s.getInputStream()));
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanQueueIfNecessary() throws IOException {
        int qSize = this.queue.size();
        if (qSize < this.loadThreshold) {
            String message = "Event queue holds " + qSize + " log events.";
            this.logInfo(message + " Not flushing yet. Load threshold of " + this.loadThreshold + " is not reached.");
            return;
        }
        LogstashSocketAppender logstashSocketAppender = this;
        synchronized (logstashSocketAppender) {
            qSize = this.queue.size();
            if (qSize < this.loadThreshold) {
                this.logInfo("Another thread flushed the queue in the meantime.");
                return;
            }
            String message = "Event queue holds " + qSize + " log events.";
            if (this.alwaysPersistEvents) {
                this.logInfo(message + " Load threshold of " + this.loadThreshold + " is reached. Flushing...");
                this.flushQueue(qSize);
            } else {
                this.queue.clear();
                this.logInfo("Cleared event queue. Discarded " + qSize + " log events.");
            }
        }
    }

    private void flushQueue(int qSize) throws IOException {
        int events;
        for (events = 0; events < qSize; ++events) {
            ILoggingEvent event = (ILoggingEvent)this.queue.poll();
            if (event == null) {
                return;
            }
            this.writeBytes(this.fallbackOutputStream, this.encoder.encode((Object)event));
        }
        this.logInfo("Successfully flushed " + events + " out of " + qSize + " events.");
    }

    public void setRemoteHost(String host) {
        this.remoteHost = host;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setReconnectionDelay(int delay) {
        this.reconnectionDelay = delay;
    }

    public int getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public void setEventDelayLimit(Duration eventDelayLimit) {
        this.eventDelayLimit = eventDelayLimit;
    }

    public Duration getEventDelayLimit() {
        return this.eventDelayLimit;
    }

    void setAcceptConnectionTimeout(int acceptConnectionTimeout) {
        this.acceptConnectionTimeout = acceptConnectionTimeout;
    }

    void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getNumberOfElementsInQueue() {
        return this.queue.size();
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        if (this.queue != null) {
            throw new IllegalStateException("Queue size must be set before initialization");
        }
        this.queueSize = queueSize;
    }

    public Encoder<ILoggingEvent> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }

    private void logInfo(String message) {
        this.addStatus((Status)new InfoStatus(message, (Object)this));
    }

    private void logWarn(String message) {
        this.addStatus((Status)new WarnStatus(message, (Object)this));
    }

    void logError(String message, Throwable t) {
        this.addStatus((Status)new ErrorStatus(message, (Object)this, t));
    }

    private void writeBytes(OutputStream outputStream, byte[] byteArray) throws IOException {
        if (byteArray == null || outputStream == null) {
            return;
        }
        outputStream.write(byteArray);
        outputStream.flush();
    }

    private void closeStreams(OutputStream ... outputStreams) {
        for (OutputStream os : outputStreams) {
            this.closeStream(os);
        }
    }

    private void closeStream(OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.close();
            outputStream = null;
        }
        catch (IOException e) {
            this.addStatus((Status)new ErrorStatus("Could not close output stream for LogstashSocketAppender.", (Object)this, (Throwable)e));
        }
    }

    @Override
    public int getEventsInQueue() {
        return this.queue.size();
    }

    private class ConnectionOverwatch
    implements Runnable {
        private final InputStream inputStream;

        public ConnectionOverwatch(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (this.inputStream.read() != -1) {
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    continue;
                }
                catch (Exception e) {
                    LogstashSocketAppender.this.logError("An unexpected error occurred: ", e);
                }
                break;
            }
        }
    }
}

