/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class StorageBucket {
    protected final String bucket;
    protected final long users;

    public StorageBucket(String bucket, long users) {
        if (bucket == null) {
            throw new IllegalArgumentException("Required value for 'bucket' is null");
        }
        this.bucket = bucket;
        this.users = users;
    }

    public String getBucket() {
        return this.bucket;
    }

    public long getUsers() {
        return this.users;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.bucket, this.users});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            StorageBucket other = (StorageBucket)obj;
            return (this.bucket == other.bucket || this.bucket.equals(other.bucket)) && this.users == other.users;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<StorageBucket> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(StorageBucket value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("bucket");
            StoneSerializers.string().serialize(value.bucket, g);
            g.writeFieldName("users");
            StoneSerializers.uInt64().serialize((Long)value.users, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public StorageBucket deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_users;
            String f_bucket;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_bucket = null;
                f_users = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("bucket".equals(field)) {
                        f_bucket = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("users".equals(field)) {
                        f_users = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_bucket == null) {
                    throw new JsonParseException(p, "Required field \"bucket\" missing.");
                }
                if (f_users == null) {
                    throw new JsonParseException(p, "Required field \"users\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            StorageBucket value = new StorageBucket(f_bucket, f_users);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

