/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class LinkPassword {
    public static final LinkPassword REMOVE_PASSWORD = new LinkPassword(Tag.REMOVE_PASSWORD, null);
    public static final LinkPassword OTHER = new LinkPassword(Tag.OTHER, null);
    private final Tag _tag;
    private final String setPasswordValue;

    private LinkPassword(Tag _tag, String setPasswordValue) {
        this._tag = _tag;
        this.setPasswordValue = setPasswordValue;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isRemovePassword() {
        return this._tag == Tag.REMOVE_PASSWORD;
    }

    public boolean isSetPassword() {
        return this._tag == Tag.SET_PASSWORD;
    }

    public static LinkPassword setPassword(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new LinkPassword(Tag.SET_PASSWORD, value);
    }

    public String getSetPasswordValue() {
        if (this._tag != Tag.SET_PASSWORD) {
            throw new IllegalStateException("Invalid tag: required Tag.SET_PASSWORD, but was Tag." + this._tag.name());
        }
        return this.setPasswordValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.setPasswordValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LinkPassword) {
            LinkPassword other = (LinkPassword)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case REMOVE_PASSWORD: {
                    return true;
                }
                case SET_PASSWORD: {
                    return this.setPasswordValue == other.setPasswordValue || this.setPasswordValue.equals(other.setPasswordValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<LinkPassword> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(LinkPassword value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case REMOVE_PASSWORD: {
                    g.writeString("remove_password");
                    break;
                }
                case SET_PASSWORD: {
                    g.writeStartObject();
                    this.writeTag("set_password", g);
                    g.writeFieldName("set_password");
                    StoneSerializers.string().serialize(value.setPasswordValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public LinkPassword deserialize(JsonParser p) throws IOException, JsonParseException {
            LinkPassword value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("remove_password".equals(tag)) {
                value = REMOVE_PASSWORD;
            } else if ("set_password".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("set_password", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = LinkPassword.setPassword(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        REMOVE_PASSWORD,
        SET_PASSWORD,
        OTHER;

    }
}

