/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.LookupError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class AddPropertiesError {
    public static final AddPropertiesError RESTRICTED_CONTENT = new AddPropertiesError(Tag.RESTRICTED_CONTENT, null, null);
    public static final AddPropertiesError OTHER = new AddPropertiesError(Tag.OTHER, null, null);
    public static final AddPropertiesError PROPERTY_FIELD_TOO_LARGE = new AddPropertiesError(Tag.PROPERTY_FIELD_TOO_LARGE, null, null);
    public static final AddPropertiesError DOES_NOT_FIT_TEMPLATE = new AddPropertiesError(Tag.DOES_NOT_FIT_TEMPLATE, null, null);
    public static final AddPropertiesError PROPERTY_GROUP_ALREADY_EXISTS = new AddPropertiesError(Tag.PROPERTY_GROUP_ALREADY_EXISTS, null, null);
    private final Tag _tag;
    private final String templateNotFoundValue;
    private final LookupError pathValue;

    private AddPropertiesError(Tag _tag, String templateNotFoundValue, LookupError pathValue) {
        this._tag = _tag;
        this.templateNotFoundValue = templateNotFoundValue;
        this.pathValue = pathValue;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isTemplateNotFound() {
        return this._tag == Tag.TEMPLATE_NOT_FOUND;
    }

    public static AddPropertiesError templateNotFound(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() < 1) {
            throw new IllegalArgumentException("String is shorter than 1");
        }
        if (!Pattern.matches("(/|ptid:).*", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new AddPropertiesError(Tag.TEMPLATE_NOT_FOUND, value, null);
    }

    public String getTemplateNotFoundValue() {
        if (this._tag != Tag.TEMPLATE_NOT_FOUND) {
            throw new IllegalStateException("Invalid tag: required Tag.TEMPLATE_NOT_FOUND, but was Tag." + this._tag.name());
        }
        return this.templateNotFoundValue;
    }

    public boolean isRestrictedContent() {
        return this._tag == Tag.RESTRICTED_CONTENT;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public boolean isPath() {
        return this._tag == Tag.PATH;
    }

    public static AddPropertiesError path(LookupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AddPropertiesError(Tag.PATH, null, value);
    }

    public LookupError getPathValue() {
        if (this._tag != Tag.PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH, but was Tag." + this._tag.name());
        }
        return this.pathValue;
    }

    public boolean isPropertyFieldTooLarge() {
        return this._tag == Tag.PROPERTY_FIELD_TOO_LARGE;
    }

    public boolean isDoesNotFitTemplate() {
        return this._tag == Tag.DOES_NOT_FIT_TEMPLATE;
    }

    public boolean isPropertyGroupAlreadyExists() {
        return this._tag == Tag.PROPERTY_GROUP_ALREADY_EXISTS;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.templateNotFoundValue, this.pathValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AddPropertiesError) {
            AddPropertiesError other = (AddPropertiesError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case TEMPLATE_NOT_FOUND: {
                    return this.templateNotFoundValue == other.templateNotFoundValue || this.templateNotFoundValue.equals(other.templateNotFoundValue);
                }
                case RESTRICTED_CONTENT: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
                case PATH: {
                    return this.pathValue == other.pathValue || this.pathValue.equals(other.pathValue);
                }
                case PROPERTY_FIELD_TOO_LARGE: {
                    return true;
                }
                case DOES_NOT_FIT_TEMPLATE: {
                    return true;
                }
                case PROPERTY_GROUP_ALREADY_EXISTS: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<AddPropertiesError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(AddPropertiesError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case TEMPLATE_NOT_FOUND: {
                    g.writeStartObject();
                    this.writeTag("template_not_found", g);
                    g.writeFieldName("template_not_found");
                    StoneSerializers.string().serialize(value.templateNotFoundValue, g);
                    g.writeEndObject();
                    break;
                }
                case RESTRICTED_CONTENT: {
                    g.writeString("restricted_content");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                    break;
                }
                case PATH: {
                    g.writeStartObject();
                    this.writeTag("path", g);
                    g.writeFieldName("path");
                    LookupError.Serializer.INSTANCE.serialize(value.pathValue, g);
                    g.writeEndObject();
                    break;
                }
                case PROPERTY_FIELD_TOO_LARGE: {
                    g.writeString("property_field_too_large");
                    break;
                }
                case DOES_NOT_FIT_TEMPLATE: {
                    g.writeString("does_not_fit_template");
                    break;
                }
                case PROPERTY_GROUP_ALREADY_EXISTS: {
                    g.writeString("property_group_already_exists");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public AddPropertiesError deserialize(JsonParser p) throws IOException, JsonParseException {
            AddPropertiesError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("template_not_found".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("template_not_found", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = AddPropertiesError.templateNotFound(fieldValue);
            } else if ("restricted_content".equals(tag)) {
                value = RESTRICTED_CONTENT;
            } else if ("other".equals(tag)) {
                value = OTHER;
            } else if ("path".equals(tag)) {
                LookupError fieldValue = null;
                Serializer.expectField("path", p);
                fieldValue = LookupError.Serializer.INSTANCE.deserialize(p);
                value = AddPropertiesError.path(fieldValue);
            } else if ("property_field_too_large".equals(tag)) {
                value = PROPERTY_FIELD_TOO_LARGE;
            } else if ("does_not_fit_template".equals(tag)) {
                value = DOES_NOT_FIT_TEMPLATE;
            } else if ("property_group_already_exists".equals(tag)) {
                value = PROPERTY_GROUP_ALREADY_EXISTS;
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        TEMPLATE_NOT_FOUND,
        RESTRICTED_CONTENT,
        OTHER,
        PATH,
        PROPERTY_FIELD_TOO_LARGE,
        DOES_NOT_FIT_TEMPLATE,
        PROPERTY_GROUP_ALREADY_EXISTS;

    }
}

